/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Messages;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class Build<P extends Project<P, B>, B extends Build<P, B>>
extends AbstractBuild<P, B> {
    private static final Logger LOGGER = Logger.getLogger(Build.class.getName());

    protected Build(P project) throws IOException {
        super(project);
    }

    protected Build(P job, Calendar timestamp) {
        super(job, timestamp);
    }

    protected Build(P project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    @Override
    public void run() {
        this.execute(this.createRunner());
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    protected Run.Runner createRunner() {
        return new BuildExecution();
    }

    protected class BuildExecution
    extends AbstractBuild.AbstractRunner {
        protected BuildExecution() {
            super(Build.this);
        }

        @Override
        protected Result doRun(@NonNull BuildListener listener) throws Exception {
            if (!this.preBuild(listener, (Collection<? extends BuildStep>)((Project)Build.this.project).getBuilders())) {
                return Result.FAILURE;
            }
            if (!this.preBuild(listener, (Collection<? extends BuildStep>)((Project)Build.this.project).getPublishersList())) {
                return Result.FAILURE;
            }
            Result r = null;
            try {
                ArrayList<BuildWrapper> wrappers = new ArrayList<BuildWrapper>(((Project)Build.this.project).getBuildWrappers().values());
                ParametersAction parameters = Build.this.getAction(ParametersAction.class);
                if (parameters != null) {
                    parameters.createBuildWrappers(Build.this, wrappers);
                }
                for (BuildWrapper w : wrappers) {
                    BuildWrapper.Environment e = w.setUp((AbstractBuild)Build.this, this.launcher, listener);
                    if (e == null) {
                        Result result = r = Result.FAILURE;
                        return result;
                    }
                    Build.this.buildEnvironments.add(e);
                }
                if (!this.build(listener, ((Project)Build.this.project).getBuilders())) {
                    r = Result.FAILURE;
                }
            }
            catch (InterruptedException e) {
                r = Executor.currentExecutor().abortResult();
                throw e;
            }
            finally {
                if (r != null) {
                    Build.this.setResult(r);
                }
            }
            return r;
        }

        @Override
        public void post2(@NonNull BuildListener listener) throws IOException, InterruptedException {
            if (!this.performAllBuildSteps(listener, ((Project)Build.this.project).getPublishersList(), true)) {
                Build.this.setResult(Result.FAILURE);
            }
            if (!this.performAllBuildSteps(listener, ((Project)Build.this.project).getProperties(), true)) {
                Build.this.setResult(Result.FAILURE);
            }
        }

        @Override
        public void cleanUp(@NonNull BuildListener listener) throws Exception {
            try {
                this.performAllBuildSteps(listener, ((Project)Build.this.project).getPublishersList(), false);
                this.performAllBuildSteps(listener, ((Project)Build.this.project).getProperties(), false);
            }
            catch (Exception x) {
                Functions.printStackTrace((Throwable)x, listener.error(Messages.Build_post_build_steps_failed()));
            }
            super.cleanUp(listener);
        }

        private boolean build(@NonNull BuildListener listener, @NonNull Collection<Builder> steps) throws IOException, InterruptedException {
            for (BuildStep buildStep : steps) {
                if (!this.perform(buildStep, listener)) {
                    LOGGER.log(Level.FINE, "{0} : {1} failed", new Object[]{Build.this, buildStep});
                    return false;
                }
                Executor executor = Build.this.getExecutor();
                if (executor == null || !executor.isInterrupted()) continue;
                throw new InterruptedException();
            }
            return true;
        }
    }

    @Deprecated
    protected class RunnerImpl
    extends BuildExecution {
        protected RunnerImpl(Build this$0) {
        }
    }
}

