/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.util.EditDistance;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class DisconnectNodeCommand
extends CLICommand {
    @Argument(metaVar="NAME", usage="Agent name, or empty string for built-in node; comma-separated list is supported", required=true, multiValued=true)
    private List<String> nodes;
    @Option(name="-m", usage="Record the reason about why you are disconnecting this node")
    public String cause;
    private static final Logger LOGGER = Logger.getLogger(DisconnectNodeCommand.class.getName());

    @Override
    public String getShortDescription() {
        return Messages.DisconnectNodeCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        boolean errorOccurred = false;
        Jenkins jenkins = Jenkins.get();
        HashSet<String> hs = new HashSet<String>(this.nodes);
        List<String> names = null;
        for (String node_s : hs) {
            try {
                Computer computer = jenkins.getComputer(node_s);
                if (computer == null) {
                    String adv;
                    if (names == null) {
                        names = ComputerSet.getComputerNames();
                    }
                    throw new IllegalArgumentException((adv = EditDistance.findNearest(node_s, names)) == null ? hudson.model.Messages.Computer_NoSuchSlaveExistsWithoutAdvice(node_s) : hudson.model.Messages.Computer_NoSuchSlaveExists(node_s, adv));
                }
                computer.cliDisconnect(this.cause);
            }
            catch (Exception e) {
                if (hs.size() == 1) {
                    throw e;
                }
                this.stderr.println(node_s + ": " + e.getMessage());
                errorOccurred = true;
            }
        }
        if (errorOccurred) {
            throw new AbortException("Error occurred while performing this command, see previous stderr output.");
        }
        return 0;
    }
}

