/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionComponent;
import hudson.ExtensionListListener;
import hudson.Main;
import hudson.init.InitMilestone;
import hudson.model.Hudson;
import hudson.util.AdaptedIterator;
import hudson.util.Iterators;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ExtensionComponentSet;
import jenkins.model.Jenkins;
import jenkins.util.io.OnMaster;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class ExtensionList<T>
extends AbstractList<T>
implements OnMaster {
    @Deprecated
    public final Hudson hudson;
    @CheckForNull
    public final Jenkins jenkins;
    public final Class<T> extensionType;
    private volatile List<ExtensionComponent<T>> extensions;
    private final List<ExtensionListListener> listeners = new CopyOnWriteArrayList<ExtensionListListener>();
    private final CopyOnWriteArrayList<ExtensionComponent<T>> legacyInstances;
    private static final Logger LOGGER = Logger.getLogger(ExtensionList.class.getName());

    @Deprecated
    protected ExtensionList(Hudson hudson, Class<T> extensionType) {
        this((Jenkins)hudson, extensionType);
    }

    protected ExtensionList(Jenkins jenkins, Class<T> extensionType) {
        this(jenkins, extensionType, new CopyOnWriteArrayList<ExtensionComponent<T>>());
    }

    @Deprecated
    protected ExtensionList(Hudson hudson, Class<T> extensionType, CopyOnWriteArrayList<ExtensionComponent<T>> legacyStore) {
        this((Jenkins)hudson, extensionType, legacyStore);
    }

    @Deprecated
    protected ExtensionList(Jenkins jenkins, Class<T> extensionType, CopyOnWriteArrayList<ExtensionComponent<T>> legacyStore) {
        this.hudson = (Hudson)jenkins;
        this.jenkins = jenkins;
        this.extensionType = extensionType;
        this.legacyInstances = legacyStore;
        if (jenkins == null) {
            this.extensions = Collections.emptyList();
        }
    }

    public void addListener(@NonNull ExtensionListListener listener) {
        this.listeners.add(listener);
    }

    @CheckForNull
    public <U extends T> U get(@NonNull Class<U> type) {
        for (T ext : this) {
            if (ext.getClass() != type) continue;
            return type.cast(ext);
        }
        return null;
    }

    @NonNull
    public <U extends T> U getInstance(@NonNull Class<U> type) throws IllegalStateException {
        for (T ext : this) {
            if (ext.getClass() != type) continue;
            return type.cast(ext);
        }
        throw new IllegalStateException("The class " + type.getName() + " was not found, potentially not yet loaded");
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return new AdaptedIterator<ExtensionComponent<T>, T>(this, Iterators.readOnly(this.ensureLoaded().iterator())){

            @Override
            protected T adapt(ExtensionComponent<T> item) {
                return item.getInstance();
            }
        };
    }

    public List<ExtensionComponent<T>> getComponents() {
        return Collections.unmodifiableList(this.ensureLoaded());
    }

    @Override
    public T get(int index) {
        return this.ensureLoaded().get(index).getInstance();
    }

    @Override
    public int size() {
        return this.ensureLoaded().size();
    }

    public List<T> reverseView() {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return ExtensionList.this.get(this.size() - index - 1);
            }

            @Override
            public int size() {
                return ExtensionList.this.size();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        try {
            boolean bl = this.removeSync(o);
            return bl;
        }
        finally {
            if (this.extensions != null) {
                this.fireOnChangeListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        try {
            for (Object o : c) {
                removed |= this.removeSync(o);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            if (this.extensions != null && removed) {
                this.fireOnChangeListeners();
            }
        }
    }

    private synchronized boolean removeSync(Object o) {
        boolean removed = this.removeComponent(this.legacyInstances, o);
        if (this.extensions != null) {
            ArrayList<ExtensionComponent<T>> r = new ArrayList<ExtensionComponent<T>>(this.extensions);
            removed |= this.removeComponent(r, o);
            this.extensions = this.sort(r);
        }
        return removed;
    }

    private boolean removeComponent(Collection<ExtensionComponent<T>> collection, Object t) {
        for (ExtensionComponent<T> c : collection) {
            if (!c.getInstance().equals(t)) continue;
            return collection.remove(c);
        }
        return false;
    }

    @Override
    public final synchronized T remove(int index) {
        T t = this.get(index);
        this.remove(t);
        return t;
    }

    @Override
    @Deprecated
    public boolean add(T t) {
        try {
            boolean bl = this.addSync(t);
            return bl;
        }
        finally {
            if (this.extensions != null) {
                this.fireOnChangeListeners();
            }
        }
    }

    private synchronized boolean addSync(T t) {
        this.legacyInstances.add(new ExtensionComponent<T>(t));
        if (this.extensions != null) {
            ArrayList<ExtensionComponent<T>> r = new ArrayList<ExtensionComponent<T>>(this.extensions);
            r.add(new ExtensionComponent<T>(t));
            this.extensions = this.sort(r);
        }
        return true;
    }

    @Override
    public void add(int index, T element) {
        this.add(element);
    }

    public T getDynamic(String className) {
        for (T t : this) {
            if (!t.getClass().getName().equals(className)) continue;
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtensionComponent<T>> ensureLoaded() {
        if (this.extensions != null) {
            return this.extensions;
        }
        if (this.jenkins == null || this.jenkins.getInitLevel().compareTo(InitMilestone.PLUGINS_PREPARED) < 0) {
            return this.legacyInstances;
        }
        Object object = this.getLoadLock();
        synchronized (object) {
            if (this.extensions == null) {
                List<ExtensionComponent<T>> r = this.load();
                r.addAll(this.legacyInstances);
                this.extensions = this.sort(r);
            }
            return this.extensions;
        }
    }

    protected Object getLoadLock() {
        return Objects.requireNonNull(this.jenkins).lookup.setIfNull(Lock.class, new Lock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public boolean refresh(ExtensionComponentSet delta) {
        Object object = this.getLoadLock();
        synchronized (object) {
            if (this.extensions == null) {
                return false;
            }
            Collection<ExtensionComponent<T>> newComponents = this.load(delta);
            if (!newComponents.isEmpty()) {
                ArrayList<ExtensionComponent<T>> components = new ArrayList<ExtensionComponent<T>>(this.extensions);
                Set instances = Collections.newSetFromMap(new IdentityHashMap());
                for (ExtensionComponent extensionComponent : components) {
                    instances.add(extensionComponent.getInstance());
                }
                boolean fireListeners = false;
                for (ExtensionComponent<T> newComponent : newComponents) {
                    if (!instances.add(newComponent.getInstance())) continue;
                    fireListeners = true;
                    components.add(newComponent);
                }
                this.extensions = this.sort(new ArrayList<ExtensionComponent<T>>(components));
                return fireListeners;
            }
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public void fireOnChangeListeners() {
        for (ExtensionListListener listener : this.listeners) {
            try {
                listener.onChange();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Error firing ExtensionListListener.onChange().", e);
            }
        }
    }

    protected List<ExtensionComponent<T>> load() {
        LOGGER.fine(() -> String.format("Loading ExtensionList '%s'", this.extensionType.getName()));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, String.format("Loading ExtensionList '%s' from", this.extensionType.getName()), new Throwable("Only present for stacktrace information"));
        }
        return Objects.requireNonNull(this.jenkins).getPluginManager().getPluginStrategy().findComponents(this.extensionType, this.hudson);
    }

    protected Collection<ExtensionComponent<T>> load(ExtensionComponentSet delta) {
        return delta.find(this.extensionType);
    }

    protected List<ExtensionComponent<T>> sort(List<ExtensionComponent<T>> r) {
        r = new ArrayList<ExtensionComponent<T>>(r);
        Collections.sort(r);
        return r;
    }

    @Deprecated
    public static <T> ExtensionList<T> create(Hudson hudson, Class<T> type) {
        return ExtensionList.create((Jenkins)hudson, type);
    }

    public static <T> ExtensionList<T> create(Jenkins jenkins, Class<T> type) {
        return new ExtensionList<T>(jenkins, type);
    }

    @NonNull
    public static <T> ExtensionList<T> lookup(Class<T> type) {
        Jenkins j = Jenkins.getInstanceOrNull();
        return j == null ? ExtensionList.create((Jenkins)null, type) : j.getExtensionList(type);
    }

    @NonNull
    public static <U> U lookupSingleton(Class<U> type) {
        ExtensionList<U> all = ExtensionList.lookup(type);
        if (Main.isUnitTest && all.isEmpty()) {
            throw new IllegalStateException("Found no instances of " + type.getName() + " registered (possible annotation processor issue); try using `mvn clean test -Dtest=\u2026` rather than an IDE test runner");
        }
        if (all.size() != 1) {
            throw new IllegalStateException("Expected 1 instance of " + type.getName() + " but got " + all.size());
        }
        return all.get(0);
    }

    @NonNull
    public static <U> U lookupFirst(Class<U> type) {
        ExtensionList<U> all = ExtensionList.lookup(type);
        if (!all.isEmpty()) {
            return all.get(0);
        }
        if (Main.isUnitTest) {
            throw new IllegalStateException("Found no instances of " + type.getName() + " registered (possible annotation processor issue); try using `mvn clean test -Dtest=\u2026` rather than an IDE test runner");
        }
        throw new IllegalStateException("Found no instances of " + type.getName() + " registered");
    }

    @Deprecated
    public static void clearLegacyInstances() {
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

