/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public final class HttpRedirect
extends RuntimeException
implements HttpResponse {
    private final int statusCode;
    private final String url;
    public static final HttpRedirect DOT = new HttpRedirect(".");
    public static HttpResponse CONTEXT_ROOT = HttpRedirect.fromContextPath("");

    public HttpRedirect(@NonNull String url) {
        this(302, url);
    }

    public HttpRedirect(int statusCode, @NonNull String url) {
        this.statusCode = statusCode;
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
    }

    @Override
    public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
        rsp.sendRedirect(this.statusCode, this.url);
    }

    @Deprecated
    public static HttpResponse fromContextPath(String relative) {
        return HttpResponses.redirectViaContextPath(relative);
    }
}

