/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public abstract class CycleDetectionStrategy {
    public static final JSONArray IGNORE_PROPERTY_ARR = new JSONArray();
    public static final JSONObject IGNORE_PROPERTY_OBJ = new JSONObject();
    public static final CycleDetectionStrategy LENIENT = new LenientCycleDetectionStrategy();
    public static final CycleDetectionStrategy NOPROP = new LenientNoRefCycleDetectionStrategy();
    public static final CycleDetectionStrategy STRICT = new StrictCycleDetectionStrategy();

    public abstract JSONArray handleRepeatedReferenceAsArray(Object var1);

    public abstract JSONObject handleRepeatedReferenceAsObject(Object var1);

    private static final class LenientCycleDetectionStrategy
    extends CycleDetectionStrategy {
        private LenientCycleDetectionStrategy() {
        }

        @Override
        public JSONArray handleRepeatedReferenceAsArray(Object reference) {
            return new JSONArray();
        }

        @Override
        public JSONObject handleRepeatedReferenceAsObject(Object reference) {
            return new JSONObject(true);
        }
    }

    private static final class LenientNoRefCycleDetectionStrategy
    extends CycleDetectionStrategy {
        private LenientNoRefCycleDetectionStrategy() {
        }

        @Override
        public JSONArray handleRepeatedReferenceAsArray(Object reference) {
            return IGNORE_PROPERTY_ARR;
        }

        @Override
        public JSONObject handleRepeatedReferenceAsObject(Object reference) {
            return IGNORE_PROPERTY_OBJ;
        }
    }

    private static final class StrictCycleDetectionStrategy
    extends CycleDetectionStrategy {
        private StrictCycleDetectionStrategy() {
        }

        @Override
        public JSONArray handleRepeatedReferenceAsArray(Object reference) {
            throw new JSONException("There is a cycle in the hierarchy!");
        }

        @Override
        public JSONObject handleRepeatedReferenceAsObject(Object reference) {
            throw new JSONException("There is a cycle in the hierarchy!");
        }
    }
}

