/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.primitive;

import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.primitive.AbstractPrimitiveMorpher;

public final class BooleanMorpher
extends AbstractPrimitiveMorpher {
    private boolean defaultValue;

    public BooleanMorpher() {
    }

    public BooleanMorpher(boolean defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanMorpher)) {
            return false;
        }
        BooleanMorpher other = (BooleanMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    public boolean morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        if (value instanceof Number) {
            if (value instanceof Double && (Double.isInfinite(((Number)value).doubleValue()) || Double.isNaN(((Number)value).doubleValue()))) {
                return true;
            }
            if (value instanceof Float && (Float.isInfinite(((Number)value).floatValue()) || Float.isNaN(((Number)value).floatValue()))) {
                return true;
            }
            long l = ((Number)value).longValue();
            return l != 0L;
        }
        String s = String.valueOf(value);
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("off")) {
            return false;
        }
        if (this.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Can't morph value: " + String.valueOf(value));
    }

    @Override
    public Class morphsTo() {
        return Boolean.TYPE;
    }
}

