/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.OpenSshCertificate;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OpenSshCertificateImpl
implements OpenSshCertificate {
    private static final long serialVersionUID = -3592634724148744943L;
    private String keyType;
    private byte[] nonce;
    private PublicKey certificatePublicKey;
    private long serial;
    private int type;
    private String id;
    private Collection<String> principals;
    private long validAfter = 0L;
    private long validBefore = -1L;
    private SortedMap<String, String> criticalOptions;
    private SortedMap<String, String> extensions;
    private String reserved;
    private PublicKey caPubKey;
    private byte[] message;
    private byte[] signature;

    @Override
    public String getRawKeyType() {
        return GenericUtils.isEmpty(this.keyType) ? null : this.keyType.split("@")[0].substring(0, this.keyType.indexOf("-cert"));
    }

    @Override
    public byte[] getNonce() {
        return this.nonce;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public PublicKey getCertPubKey() {
        return this.certificatePublicKey;
    }

    @Override
    public long getSerial() {
        return this.serial;
    }

    @Override
    public OpenSshCertificate.Type getType() {
        return OpenSshCertificate.Type.fromCode(this.type);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<String> getPrincipals() {
        return this.principals == null ? Collections.emptyList() : this.principals;
    }

    @Override
    public long getValidAfter() {
        return this.validAfter;
    }

    @Override
    public long getValidBefore() {
        return this.validBefore;
    }

    @Override
    public List<OpenSshCertificate.CertificateOption> getCriticalOptions() {
        if (this.criticalOptions == null || this.criticalOptions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(this.criticalOptions.size());
        this.criticalOptions.forEach((k, v) -> list.add(new OpenSshCertificate.CertificateOption((String)k, (String)v)));
        return Collections.unmodifiableList(list);
    }

    @Override
    public SortedMap<String, String> getCriticalOptionsMap() {
        return this.criticalOptions == null ? Collections.emptySortedMap() : Collections.unmodifiableSortedMap(this.criticalOptions);
    }

    @Override
    public List<OpenSshCertificate.CertificateOption> getExtensions() {
        if (this.extensions == null || this.extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(this.extensions.size());
        this.extensions.forEach((k, v) -> list.add(new OpenSshCertificate.CertificateOption((String)k, (String)v)));
        return Collections.unmodifiableList(list);
    }

    @Override
    public SortedMap<String, String> getExtensionsMap() {
        return this.extensions == null ? Collections.emptySortedMap() : Collections.unmodifiableSortedMap(this.extensions);
    }

    @Override
    public String getReserved() {
        return this.reserved;
    }

    @Override
    public PublicKey getCaPubKey() {
        return this.caPubKey;
    }

    @Override
    public byte[] getMessage() {
        return this.message;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public byte[] getRawSignature() {
        if (this.signature == null) {
            return null;
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(this.signature);
        buffer.getString();
        return buffer.getBytes();
    }

    @Override
    public String getSignatureAlgorithm() {
        return NumberUtils.isEmpty(this.signature) ? null : new ByteArrayBuffer(this.signature).getString();
    }

    @Override
    public String getAlgorithm() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return GenericUtils.EMPTY_BYTE_ARRAY;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public void setCertPubKey(PublicKey certificatePublicKey) {
        this.certificatePublicKey = certificatePublicKey;
    }

    public void setSerial(long serial) {
        this.serial = serial;
    }

    public void setType(OpenSshCertificate.Type type) {
        this.type = type.getCode();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPrincipals(Collection<String> principals) {
        this.principals = principals;
    }

    public void setValidAfter(long validAfter) {
        this.validAfter = validAfter;
    }

    public void setValidAfter(Instant validAfter) {
        if (validAfter == null) {
            this.setValidAfter(0L);
        } else if (Instant.EPOCH.compareTo(validAfter) <= 0) {
            this.setValidAfter(validAfter.getEpochSecond());
        } else {
            throw new IllegalArgumentException("Valid-after cannot be < epoch");
        }
    }

    public void setValidBefore(long validBefore) {
        this.validBefore = validBefore;
    }

    public void setValidBefore(Instant validBefore) {
        if (validBefore == null) {
            this.setValidBefore(-1L);
        } else if (Instant.EPOCH.compareTo(validBefore) <= 0) {
            this.setValidBefore(validBefore.getEpochSecond());
        } else {
            throw new IllegalArgumentException("Valid-before cannot be < epoch");
        }
    }

    public void setCriticalOptions(List<OpenSshCertificate.CertificateOption> criticalOptions) {
        if (criticalOptions == null || criticalOptions.isEmpty()) {
            this.criticalOptions = null;
        } else {
            this.criticalOptions = new TreeMap<String, String>();
            for (OpenSshCertificate.CertificateOption option : criticalOptions) {
                String data = option.getData();
                this.criticalOptions.put(option.getName(), data == null ? "" : data);
            }
        }
    }

    public void setCriticalOptions(Map<String, String> criticalOptions) {
        if (criticalOptions == null || criticalOptions.isEmpty()) {
            this.criticalOptions = null;
        } else {
            this.criticalOptions = new TreeMap<String, String>();
            criticalOptions.forEach((k, v) -> {
                String data = v == null ? "" : v;
                this.criticalOptions.put((String)k, data);
            });
        }
    }

    public boolean addCriticalOption(String name, String value) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "Critical option name must be set");
        if (value == null) {
            if (this.criticalOptions == null) {
                return true;
            }
            return this.criticalOptions.remove(key) == null;
        }
        if (this.criticalOptions == null) {
            this.criticalOptions = new TreeMap<String, String>();
        }
        return this.criticalOptions.put(key, value) == null;
    }

    public void setExtensions(List<OpenSshCertificate.CertificateOption> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            this.extensions = null;
        } else {
            this.extensions = new TreeMap<String, String>();
            for (OpenSshCertificate.CertificateOption option : extensions) {
                String data = option.getData();
                this.extensions.put(option.getName(), data == null ? "" : data);
            }
        }
    }

    public void setExtensions(Map<String, String> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            this.extensions = null;
        } else {
            this.extensions = new TreeMap<String, String>();
            extensions.forEach((k, v) -> {
                String data = v == null ? "" : v;
                this.extensions.put((String)k, data);
            });
        }
    }

    public boolean addExtension(String name, String value) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "Extension name must be set");
        if (value == null) {
            if (this.extensions == null) {
                return true;
            }
            return this.extensions.remove(key) == null;
        }
        if (this.extensions == null) {
            this.extensions = new TreeMap<String, String>();
        }
        return this.extensions.put(key, value) == null;
    }

    public void setReserved(String reserved) {
        this.reserved = reserved;
    }

    public void setCaPubKey(PublicKey caPubKey) {
        this.caPubKey = caPubKey;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    private static String toDate(long timestamp) {
        if (timestamp < 0L) {
            return "infinity";
        }
        Date date = new Date(TimeUnit.SECONDS.toMillis(timestamp));
        return date.toString();
    }

    public String toString() {
        return this.getKeyType() + "[id=" + this.getId() + ", serial=" + this.getSerial() + ", type=" + (Object)((Object)this.getType()) + ", validAfter=" + OpenSshCertificateImpl.toDate(this.getValidAfter()) + ", validBefore=" + OpenSshCertificateImpl.toDate(this.getValidBefore()) + "]";
    }
}

