/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner;

import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.ClassConstant;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.FieldRefConstant;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.InterfaceMethodRefConstant;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.MethodRefConstant;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.NameAndTypeConstant;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.Utf8Constant;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstantPool {
    final Object[] constants;

    ConstantPool(int size) {
        this.constants = new Object[size];
    }

    public <T> Iterable<T> list(final Class<T> type) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int idx = -1;
                    {
                        this.seek();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.idx < ConstantPool.this.constants.length;
                    }

                    @Override
                    public T next() {
                        Object v = ConstantPool.this.constants[this.idx];
                        this.seek();
                        return type.cast(v);
                    }

                    private void seek() {
                        do {
                            ++this.idx;
                        } while (this.hasNext() && !type.isInstance(ConstantPool.this.constants[this.idx]));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public int size() {
        return this.constants.length;
    }

    NameAndTypeConstant nameAndTypeAt(int i) {
        if (this.constants[i] == null) {
            this.constants[i] = new NameAndTypeConstant();
        }
        return (NameAndTypeConstant)this.constants[i];
    }

    FieldRefConstant fieldRefAt(int i) {
        if (this.constants[i] == null) {
            this.constants[i] = new FieldRefConstant();
        }
        return (FieldRefConstant)this.constants[i];
    }

    MethodRefConstant methodRefAt(int i) {
        if (this.constants[i] == null) {
            this.constants[i] = new MethodRefConstant();
        }
        return (MethodRefConstant)this.constants[i];
    }

    InterfaceMethodRefConstant interfaceMethodRefAt(int i) {
        if (this.constants[i] == null) {
            this.constants[i] = new InterfaceMethodRefConstant();
        }
        return (InterfaceMethodRefConstant)this.constants[i];
    }

    ClassConstant classAt(int i) {
        if (this.constants[i] == null) {
            this.constants[i] = new ClassConstant();
        }
        return (ClassConstant)this.constants[i];
    }

    Utf8Constant utf8At(int i) {
        if (this.constants[i] == null) {
            this.constants[i] = new Utf8Constant();
        }
        return (Utf8Constant)this.constants[i];
    }

    void set(int i, Object value) {
        assert (this.constants[i] == null);
        this.constants[i] = value;
    }

    public String toString() {
        return Arrays.asList(this.constants).toString();
    }
}

