/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.model.PersistentDescriptor;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.security.ResourceDomainConfiguration;
import jenkins.security.csp.AdvancedConfiguration;
import jenkins.security.csp.AdvancedConfigurationDescriptor;
import jenkins.security.csp.CspHeader;
import jenkins.security.csp.CspHeaderDecider;
import jenkins.security.csp.impl.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"contentSecurityPolicy"})
@Restricted(value={NoExternalUse.class})
public class CspConfiguration
extends GlobalConfiguration
implements PersistentDescriptor {
    protected Boolean enforce;
    private final DescribableList<AdvancedConfiguration, AdvancedConfigurationDescriptor> advanced = new DescribableList(this);

    @Override
    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public boolean isEnforce() {
        return this.enforce != null && this.enforce != false;
    }

    @DataBoundSetter
    public void setEnforce(boolean enforce) {
        this.enforce = enforce;
        this.save();
    }

    @Override
    protected XmlFile getConfigFile() {
        return super.getConfigFile();
    }

    @Restricted(value={DoNotUse.class})
    public boolean isShowHeaderConfiguration() {
        Optional<CspHeaderDecider> currentDecider = CspHeaderDecider.getCurrentDecider();
        return currentDecider.filter(cspHeaderDecider -> cspHeaderDecider instanceof ConfigurationHeaderDecider).isPresent();
    }

    @Restricted(value={DoNotUse.class})
    public CspHeaderDecider getCurrentDecider() {
        return CspHeaderDecider.getCurrentDecider().orElse(null);
    }

    @POST
    public FormValidation doCheckEnforce(@QueryParameter boolean enforce) {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return FormValidation.ok();
        }
        if (!this.getConfigFile().exists()) {
            if (enforce) {
                if (ResourceDomainConfiguration.isResourceDomainConfigured()) {
                    return FormValidation.ok(Messages.CspConfiguration_UndefinedToTrueWithResourceDomain());
                }
                return FormValidation.okWithMarkup(Messages.CspConfiguration_UndefinedToTrueWithoutResourceDomain(Jenkins.get().getRootUrlFromRequest()));
            }
            return FormValidation.warning(Messages.CspConfiguration_UndefinedToFalse());
        }
        if (enforce && !ResourceDomainConfiguration.isResourceDomainConfigured()) {
            if (ExtensionList.lookupSingleton(CspConfiguration.class).isEnforce()) {
                return FormValidation.warningWithMarkup(Messages.CspConfiguration_TrueToTrueWithoutResourceDomain(Jenkins.get().getRootUrlFromRequest()));
            }
            return FormValidation.okWithMarkup(Messages.CspConfiguration_FalseToTrueWithoutResourceDomain(Jenkins.get().getRootUrlFromRequest()));
        }
        return FormValidation.ok();
    }

    public List<? extends AdvancedConfiguration> getAdvanced() {
        return this.advanced;
    }

    @DataBoundSetter
    public void setAdvanced(List<? extends AdvancedConfiguration> advanced) throws IOException {
        this.advanced.replaceBy(advanced);
        this.save();
    }

    public DescriptorExtensionList<AdvancedConfiguration, AdvancedConfigurationDescriptor> getAdvancedDescriptors() {
        return AdvancedConfiguration.all();
    }

    @Extension
    public static class ConfigurationHeaderDecider
    implements CspHeaderDecider {
        @Override
        public Optional<CspHeader> decide() {
            Boolean enforce = ExtensionList.lookupSingleton(CspConfiguration.class).enforce;
            if (enforce == null) {
                return Optional.empty();
            }
            if (enforce.booleanValue()) {
                return Optional.of(CspHeader.ContentSecurityPolicy);
            }
            return Optional.of(CspHeader.ContentSecurityPolicyReportOnly);
        }
    }
}

