/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp;

import java.util.ArrayList;
import java.util.List;
import jenkins.security.csp.Contributor;
import jenkins.security.csp.CspBuilder;
import jenkins.security.csp.Directive;
import jenkins.security.csp.FetchDirective;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public abstract class SimpleContributor
implements Contributor {
    private final List<Directive> allowlist = new ArrayList<Directive>();

    protected void allow(FetchDirective directive, String ... domain) {
        this.allowlist.add(new Directive(directive.toKey(), null, List.of(domain)));
    }

    @Override
    public final void apply(CspBuilder cspBuilder) {
        this.allowlist.forEach(entry -> cspBuilder.add(entry.name(), entry.values().toArray(new String[0])));
    }
}

