/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.experimentalflags;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.User;
import jenkins.model.experimentalflags.UserExperimentalFlagsProperty;

public abstract class UserExperimentalFlag<T>
implements ExtensionPoint {
    private final String flagKey;

    protected UserExperimentalFlag(@NonNull String flagKey) {
        this.flagKey = flagKey;
    }

    @NonNull
    public abstract T getDefaultValue();

    @Nullable
    public abstract Object serializeValue(T var1);

    @Nullable
    protected abstract T deserializeValue(Object var1);

    public abstract String getDisplayName();

    @Nullable
    public abstract String getShortDescription();

    @NonNull
    public String getFlagKey() {
        return this.flagKey;
    }

    @NonNull
    public T getFlagValue() {
        User currentUser = User.current();
        if (currentUser == null) {
            return this.getDefaultValue();
        }
        return this.getFlagValue(currentUser);
    }

    @NonNull
    public T getFlagValue(User user) {
        UserExperimentalFlagsProperty property = user.getProperty(UserExperimentalFlagsProperty.class);
        if (property == null) {
            return this.getDefaultValue();
        }
        Object value = property.getFlagValue(this.flagKey);
        if (value == null) {
            return this.getDefaultValue();
        }
        T convertedValue = this.deserializeValue(value);
        if (convertedValue == null) {
            return this.getDefaultValue();
        }
        return convertedValue;
    }

    public String getFlagDescriptionPage() {
        return "flagDescription.jelly";
    }

    public String getFlagConfigPage() {
        return "flagConfig.jelly";
    }

    @NonNull
    public static ExtensionList<UserExperimentalFlag> all() {
        return ExtensionList.lookup(UserExperimentalFlag.class);
    }

    @CheckForNull
    public static <T> T getFlagValueForCurrentUser(String flagClassCanonicalName) {
        Class<?> flagClass;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(flagClassCanonicalName);
            if (!UserExperimentalFlag.class.isAssignableFrom(clazz)) {
                return null;
            }
            flagClass = clazz;
        }
        catch (Exception e) {
            return null;
        }
        UserExperimentalFlag userExperimentalFlag = (UserExperimentalFlag)UserExperimentalFlag.all().get(flagClass);
        if (userExperimentalFlag == null) {
            return null;
        }
        return userExperimentalFlag.getFlagValue();
    }
}

