/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.lifecycle.Lifecycle;
import hudson.model.Api;
import hudson.model.DownloadService;
import hudson.model.UpdateCenter;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.TextFile;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import jenkins.plugins.DetachedPluginsUtil;
import jenkins.security.UpdateSiteWarningsConfiguration;
import jenkins.security.UpdateSiteWarningsMonitor;
import jenkins.util.JSONSignatureValidator;
import jenkins.util.MemoryReductionUtil;
import jenkins.util.PluginLabelUtil;
import jenkins.util.SystemProperties;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class UpdateSite {
    private volatile transient long dataTimestamp;
    private volatile transient long lastAttempt;
    private volatile transient long retryWindow;
    private transient Data data;
    private final String id;
    private final String url;
    private static final String signatureValidatorPrefix = "update site";
    private static final Set<String> warnedMissing = Collections.synchronizedSet(new HashSet());
    static final Predicate<Object> IS_DEP_PREDICATE = x -> x instanceof JSONObject && UpdateSite.get((JSONObject)x, "name") != null;
    static final Predicate<Object> IS_NOT_OPTIONAL = x -> "false".equals(UpdateSite.get((JSONObject)x, "optional"));
    private static final long DAY = TimeUnit.DAYS.toMillis(1L);
    private static final Logger LOGGER = Logger.getLogger(UpdateSite.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean neverUpdate = SystemProperties.getBoolean(UpdateCenter.class.getName() + ".never");

    public UpdateSite(String id, String url) {
        this.id = id;
        this.url = url;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public long getDataTimestamp() {
        assert (this.dataTimestamp >= 0L);
        return this.dataTimestamp;
    }

    @CheckForNull
    public Future<FormValidation> updateDirectly() {
        return this.updateDirectly(DownloadService.signatureCheck);
    }

    @Deprecated
    @CheckForNull
    public Future<FormValidation> updateDirectly(final boolean signatureCheck) {
        if (!this.getDataFile().exists() || this.isDue()) {
            return Jenkins.get().getUpdateCenter().updateService.submit(new Callable<FormValidation>(){

                @Override
                public FormValidation call() throws Exception {
                    return UpdateSite.this.updateDirectlyNow(signatureCheck);
                }
            });
        }
        return null;
    }

    public URLConnection connect(URL src) throws IOException {
        return ProxyConfiguration.open(src);
    }

    public void preValidate(URL src) throws IOException {
    }

    @NonNull
    public FormValidation updateDirectlyNow() throws IOException {
        return this.updateDirectlyNow(DownloadService.signatureCheck);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public FormValidation updateDirectlyNow(boolean signatureCheck) throws IOException {
        return this.updateData(DownloadService.loadJSON(new URL(this.getUrl() + "?id=" + URLEncoder.encode(this.getId(), StandardCharsets.UTF_8) + "&version=" + URLEncoder.encode(Jenkins.VERSION, StandardCharsets.UTF_8))), signatureCheck);
    }

    protected FormValidation updateData(String json, boolean signatureCheck) throws IOException {
        this.dataTimestamp = System.currentTimeMillis();
        JSONObject o = JSONObject.fromObject((Object)json);
        try {
            int v = o.getInt("updateCenterVersion");
            if (v != 1) {
                throw new IllegalArgumentException("Unrecognized update center version: " + v);
            }
        }
        catch (JSONException x) {
            throw new IllegalArgumentException("Could not find (numeric) updateCenterVersion in " + json, x);
        }
        if (signatureCheck) {
            FormValidation e = this.verifySignatureInternal(o);
            if (e.kind != FormValidation.Kind.OK) {
                LOGGER.severe(e.toString());
                return e;
            }
        }
        LOGGER.fine(() -> "Obtained the latest update center data file for UpdateSource " + this.id);
        this.retryWindow = 0L;
        this.getDataFile().write(json);
        this.data = new Data(o);
        return FormValidation.ok();
    }

    public FormValidation doVerifySignature() throws IOException {
        return this.verifySignatureInternal(this.getJSONObject());
    }

    protected UpdateCenter.InstallationJob createInstallationJob(Plugin plugin, UpdateCenter uc, boolean dynamicLoad) {
        UpdateCenter updateCenter = uc;
        Objects.requireNonNull(updateCenter);
        return updateCenter.new UpdateCenter.InstallationJob(plugin, this, Jenkins.getAuthentication2(), dynamicLoad);
    }

    @Restricted(value={NoExternalUse.class})
    public final FormValidation verifySignatureInternal(JSONObject o) throws IOException {
        String message;
        FormValidation result = this.getJsonSignatureValidator(null).verifySignature(o);
        if (result.kind == FormValidation.Kind.ERROR && (message = result.getMessage()) != null) {
            Object updatedMessage = message.contains(signatureValidatorPrefix) && message.contains(" Path") && !message.contains(this.url) ? message.replaceAll("(update site\\s+).*?(\\s+Path)", "$1" + this.url + "$2") : message + " (URL: " + this.url + ")";
            return FormValidation.error((String)updatedMessage);
        }
        return result;
    }

    @Deprecated
    @NonNull
    protected JSONSignatureValidator getJsonSignatureValidator() {
        return this.getJsonSignatureValidator(null);
    }

    @NonNull
    protected JSONSignatureValidator getJsonSignatureValidator(@CheckForNull String name) {
        if (name == null) {
            name = "update site '" + this.id + "'";
        }
        return new JSONSignatureValidator((String)name);
    }

    public synchronized boolean isDue() {
        boolean due;
        if (neverUpdate) {
            return false;
        }
        if (this.dataTimestamp == 0L) {
            this.dataTimestamp = this.getDataFile().file.lastModified();
        }
        long now = System.currentTimeMillis();
        this.retryWindow = Math.max(this.retryWindow, TimeUnit.SECONDS.toMillis(15L));
        boolean bl = due = now - this.dataTimestamp > DAY && now - this.lastAttempt > this.retryWindow;
        if (due) {
            this.lastAttempt = now;
            this.retryWindow = Math.min(this.retryWindow * 2L, TimeUnit.HOURS.toMillis(1L));
        }
        return due;
    }

    @RequirePOST
    public HttpResponse doInvalidateData() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.dataTimestamp = 0L;
        this.data = null;
        return HttpResponses.ok();
    }

    @CheckForNull
    public Data getData() {
        JSONObject o;
        if (this.data == null && (o = this.getJSONObject()) != null) {
            this.data = new Data(o);
        }
        return this.data;
    }

    boolean hasUnparsedData() {
        return this.data == null && this.getDataFile().exists();
    }

    public JSONObject getJSONObject() {
        TextFile df = this.getDataFile();
        if (df.exists()) {
            long start = System.nanoTime();
            try {
                JSONObject o = JSONObject.fromObject((Object)df.read());
                LOGGER.fine(() -> String.format("Loaded and parsed %s in %.01fs", df, (double)(System.nanoTime() - start) / 1.0E9));
                return o;
            }
            catch (IOException | JSONException e) {
                LOGGER.log(Level.SEVERE, "Failed to parse " + String.valueOf(df), e);
                try {
                    df.delete();
                }
                catch (IOException e2) {
                    LOGGER.log(Level.SEVERE, "Failed to delete " + String.valueOf(df), e2);
                }
                return null;
            }
        }
        return null;
    }

    @Exported
    public List<Plugin> getAvailables() {
        ArrayList<Plugin> r = new ArrayList<Plugin>();
        Data data = this.getData();
        if (data == null) {
            return Collections.emptyList();
        }
        for (Plugin p : data.plugins.values()) {
            if (p.getInstalled() != null) continue;
            r.add(p);
        }
        r.sort((plugin, t1) -> {
            int pop = t1.popularity.compareTo(plugin.popularity);
            if (pop != 0) {
                return pop;
            }
            return plugin.getDisplayName().compareTo(t1.getDisplayName());
        });
        return r;
    }

    @CheckForNull
    public Plugin getPlugin(String artifactId) {
        Data dt = this.getData();
        if (dt == null) {
            return null;
        }
        return dt.plugins.get(artifactId);
    }

    public Api getApi() {
        return new Api(this);
    }

    @Exported
    @CheckForNull
    public String getConnectionCheckUrl() {
        Data dt = this.getData();
        if (dt == null) {
            return "http://www.google.com/";
        }
        return dt.connectionCheckUrl;
    }

    private TextFile getDataFile() {
        return new TextFile(new File(Jenkins.get().getRootDir(), "updates/" + this.getId() + ".json"));
    }

    @Exported
    public List<Plugin> getUpdates() {
        Data data = this.getData();
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<Plugin> r = new ArrayList<Plugin>();
        for (PluginWrapper pw : Jenkins.get().getPluginManager().getPlugins()) {
            Plugin p = pw.getUpdateInfo();
            if (p == null) continue;
            r.add(p);
        }
        return r;
    }

    @Exported
    public boolean hasUpdates() {
        Data data = this.getData();
        if (data == null) {
            return false;
        }
        for (PluginWrapper pw : Jenkins.get().getPluginManager().getPlugins()) {
            if (pw.isBundled() || pw.getUpdateInfo() == null) continue;
            return true;
        }
        return false;
    }

    @Exported
    public String getUrl() {
        return this.url;
    }

    @Exported
    public String getSuggestedPluginsUrl() {
        String updateCenterJsonUrl = this.getUrl();
        return updateCenterJsonUrl.replace("/update-center.json", "/platform-plugins.json");
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public String getMetadataUrlForDownloadable(String downloadable) {
        String siteUrl = this.getUrl();
        String updateSiteMetadataUrl = null;
        int baseUrlEnd = siteUrl.indexOf("update-center.json");
        if (baseUrlEnd != -1) {
            String siteBaseUrl = siteUrl.substring(0, baseUrlEnd);
            updateSiteMetadataUrl = siteBaseUrl + "updates/" + downloadable;
        } else {
            LOGGER.log(Level.WARNING, "Url {0} does not look like an update center:", siteUrl);
        }
        return updateSiteMetadataUrl;
    }

    @Deprecated
    public String getDownloadUrl() {
        return this.url;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isLegacyDefault() {
        return this.isJenkinsCI();
    }

    private boolean isJenkinsCI() {
        return this.url != null && "default".equals(this.id) && this.url.startsWith("http://updates.jenkins-ci.org/");
    }

    private static String get(JSONObject o, String prop) {
        if (o.has(prop)) {
            return o.getString(prop);
        }
        return null;
    }

    public final class Data {
        public final String sourceId;
        public final Entry core;
        public final Map<String, Plugin> plugins = new TreeMap<String, Plugin>(String.CASE_INSENSITIVE_ORDER);
        private final Set<Warning> warnings = new HashSet<Warning>();
        private final Map<String, Deprecation> deprecations = new HashMap<String, Deprecation>();
        public final String connectionCheckUrl;
        @Restricted(value={NoExternalUse.class})
        public final boolean healthScoresAvailable;

        Data(JSONObject o) {
            JSONObject deprecations;
            this.sourceId = Util.intern((String)o.get("id"));
            JSONObject c = o.optJSONObject("core");
            this.core = c != null ? new Entry(this.sourceId, c, UpdateSite.this.url) : null;
            JSONArray w = o.optJSONArray("warnings");
            if (w != null) {
                for (int i = 0; i < w.size(); ++i) {
                    try {
                        this.warnings.add(new Warning(w.getJSONObject(i)));
                        continue;
                    }
                    catch (JSONException ex) {
                        LOGGER.log(Level.WARNING, "Failed to parse JSON for warning", ex);
                    }
                }
            }
            if ((deprecations = o.optJSONObject("deprecations")) != null) {
                Iterator it = deprecations.keys();
                while (it.hasNext()) {
                    try {
                        String referenceUrl;
                        String pluginId = it.next().toString();
                        JSONObject entry = deprecations.getJSONObject(pluginId);
                        if (entry == null || (referenceUrl = entry.getString("url")) == null) continue;
                        this.deprecations.put(pluginId, new Deprecation(referenceUrl));
                    }
                    catch (RuntimeException ex) {
                        LOGGER.log(Level.WARNING, "Failed to parse JSON for deprecation", ex);
                    }
                }
            }
            boolean healthScoresAvailable = false;
            for (Map.Entry e : o.getJSONObject("plugins").entrySet()) {
                Plugin p = new Plugin(this.sourceId, (JSONObject)e.getValue());
                List<PluginWrapper.Dependency> implicitDeps = DetachedPluginsUtil.getImpliedDependencies(p.name, p.requiredCore);
                if (!implicitDeps.isEmpty()) {
                    for (PluginWrapper.Dependency dep : implicitDeps) {
                        if (p.dependencies.containsKey(dep.shortName)) continue;
                        p.dependencies.put(dep.shortName, dep.version);
                    }
                }
                this.plugins.put(Util.intern((String)e.getKey()), p);
                if (p.healthScore != null) {
                    healthScoresAvailable = true;
                }
                if (!p.hasCategory("deprecated") || this.deprecations.containsKey(p.name)) continue;
                this.deprecations.put(p.name, new Deprecation(p.wiki));
            }
            this.healthScoresAvailable = healthScoresAvailable;
            this.connectionCheckUrl = (String)o.get("connectionCheckUrl");
        }

        @Restricted(value={NoExternalUse.class})
        public Set<Warning> getWarnings() {
            return this.warnings;
        }

        @Restricted(value={NoExternalUse.class})
        public Map<String, Deprecation> getDeprecations() {
            return this.deprecations;
        }

        public boolean hasCoreUpdates() {
            return this.core != null && this.core.isNewerThan(Jenkins.VERSION);
        }

        public boolean canUpgrade() {
            return Lifecycle.get().canRewriteHudsonWar();
        }
    }

    public final class Plugin
    extends Entry {
        @Exported
        public final String wiki;
        @Exported
        public final String title;
        @Exported
        public final String excerpt;
        @Exported
        public final String compatibleSinceVersion;
        @Exported
        public final String requiredCore;
        @Exported
        @CheckForNull
        public final String[] categories;
        @Exported
        public final Map<String, String> dependencies;
        @Exported
        public final Map<String, String> optionalDependencies;
        private Set<Plugin> incompatibleParentPlugins;
        @Exported
        public final Date releaseTimestamp;
        @Restricted(value={NoExternalUse.class})
        public final Double popularity;
        @Restricted(value={NoExternalUse.class})
        public IssueTracker[] issueTrackers;
        @Restricted(value={NoExternalUse.class})
        public final Integer healthScore;
        @Restricted(value={NoExternalUse.class})
        public final String healthScoreClass;

        @DataBoundConstructor
        public Plugin(String sourceId, JSONObject o) {
            super(sourceId, o, UpdateSite.this.url);
            this.wiki = UpdateSite.get(o, "wiki");
            this.title = UpdateSite.get(o, "title");
            this.excerpt = UpdateSite.get(o, "excerpt");
            this.compatibleSinceVersion = Util.intern(UpdateSite.get(o, "compatibleSinceVersion"));
            this.requiredCore = Util.intern(UpdateSite.get(o, "requiredCore"));
            String releaseTimestamp = UpdateSite.get(o, "releaseTimestamp");
            Date date = null;
            if (releaseTimestamp != null) {
                try {
                    date = Date.from(Instant.parse(releaseTimestamp));
                }
                catch (RuntimeException ex) {
                    LOGGER.log(Level.FINE, "Failed to parse releaseTimestamp for " + this.title + " from " + sourceId, ex);
                }
            }
            String popularityFromJson = UpdateSite.get(o, "popularity");
            double popularity = 0.0;
            if (popularityFromJson != null) {
                try {
                    popularity = Double.parseDouble(popularityFromJson);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.FINE, "Failed to parse popularity: '" + popularityFromJson + "' for plugin " + this.title);
                }
            }
            this.popularity = popularity;
            this.releaseTimestamp = date;
            this.categories = o.has("labels") ? PluginLabelUtil.canonicalLabels(o.getJSONArray("labels")) : null;
            this.issueTrackers = o.has("issueTrackers") ? (IssueTracker[])o.getJSONArray("issueTrackers").stream().map(IssueTracker::createFromJSONObject).filter(Objects::nonNull).toArray(IssueTracker[]::new) : null;
            JSONArray ja = o.getJSONArray("dependencies");
            int depCount = (int)ja.stream().filter(IS_DEP_PREDICATE.and(IS_NOT_OPTIONAL)).count();
            int optionalDepCount = (int)ja.stream().filter(IS_DEP_PREDICATE.and(IS_NOT_OPTIONAL.negate())).count();
            this.dependencies = MemoryReductionUtil.getPresizedMutableMap(depCount);
            this.optionalDependencies = MemoryReductionUtil.getPresizedMutableMap(optionalDepCount);
            this.healthScore = o.has("health") ? Integer.valueOf(o.getInt("health")) : null;
            this.healthScoreClass = this.healthScore != null ? PluginWrapper.getHealthScoreClassForScore(this.healthScore) : null;
            for (Object jo : o.getJSONArray("dependencies")) {
                JSONObject depObj = (JSONObject)jo;
                String depName = Util.intern(UpdateSite.get(depObj, "name"));
                if (depName == null) continue;
                if (UpdateSite.get(depObj, "optional").equals("false")) {
                    this.dependencies.put(depName, Util.intern(UpdateSite.get(depObj, "version")));
                    continue;
                }
                this.optionalDependencies.put(depName, Util.intern(UpdateSite.get(depObj, "version")));
            }
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isDeprecated() {
            return this.getDeprecation() != null;
        }

        @Restricted(value={NoExternalUse.class})
        public Deprecation getDeprecation() {
            return Jenkins.get().getUpdateCenter().getSite(this.sourceId).getData().getDeprecations().get(this.name);
        }

        public String getDisplayName() {
            String displayName = this.title != null ? this.title : this.name;
            String removePrefix = "Jenkins ";
            if (displayName != null && displayName.startsWith(removePrefix)) {
                return displayName.substring(removePrefix.length());
            }
            return displayName;
        }

        @Exported
        public PluginWrapper getInstalled() {
            PluginManager pm = Jenkins.get().getPluginManager();
            return pm.getPlugin(this.name);
        }

        @Restricted(value={NoExternalUse.class})
        @Exported
        public boolean isCompatible() {
            return this.isCompatible(new PluginManager.MetadataCache());
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isCompatible(PluginManager.MetadataCache cache) {
            return this.isCompatibleWithInstalledVersion() && !this.isForNewerHudson() && this.isNeededDependenciesCompatibleWithInstalledVersion(cache) && !this.isNeededDependenciesForNewerJenkins(cache);
        }

        @Exported
        public boolean isCompatibleWithInstalledVersion() {
            PluginWrapper installedVersion = this.getInstalled();
            return installedVersion == null || this.compatibleSinceVersion == null || !new VersionNumber(installedVersion.getVersion()).isOlderThan(new VersionNumber(this.compatibleSinceVersion));
        }

        @Exported
        public List<Plugin> getNeededDependencies() {
            PluginWrapper current;
            Plugin depPlugin;
            VersionNumber requiredVersion;
            ArrayList<Plugin> deps = new ArrayList<Plugin>();
            for (Map.Entry<String, String> e : this.dependencies.entrySet()) {
                requiredVersion = e.getValue() != null ? new VersionNumber(e.getValue()) : null;
                depPlugin = Jenkins.get().getUpdateCenter().getPlugin(e.getKey(), requiredVersion);
                if (depPlugin == null) {
                    LOGGER.log(warnedMissing.add(e.getKey()) ? Level.WARNING : Level.FINE, "Could not find dependency {0} of {1}", new Object[]{e.getKey(), this.name});
                    continue;
                }
                current = depPlugin.getInstalled();
                if (current == null) {
                    deps.add(depPlugin);
                    continue;
                }
                if (current.isOlderThan(requiredVersion)) {
                    deps.add(depPlugin);
                    continue;
                }
                if (current.isEnabled()) continue;
                deps.add(depPlugin);
            }
            for (Map.Entry<String, String> e : this.optionalDependencies.entrySet()) {
                VersionNumber versionNumber = requiredVersion = e.getValue() != null ? new VersionNumber(e.getValue()) : null;
                depPlugin = Jenkins.get().getUpdateCenter().getPlugin(e.getKey(), requiredVersion);
                if (depPlugin == null || (current = depPlugin.getInstalled()) == null || !current.isOlderThan(requiredVersion)) continue;
                deps.add(depPlugin);
            }
            return deps;
        }

        public boolean isForNewerHudson() {
            try {
                return this.requiredCore != null && new VersionNumber(this.requiredCore).isNewerThan(new VersionNumber(Jenkins.VERSION.replaceFirst("SHOT *\\(private.*\\)", "SHOT")));
            }
            catch (NumberFormatException nfe) {
                return true;
            }
        }

        public VersionNumber getNeededDependenciesRequiredCore() {
            VersionNumber versionNumber = null;
            try {
                versionNumber = this.requiredCore == null ? null : new VersionNumber(this.requiredCore);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (Plugin p : this.getNeededDependencies()) {
                VersionNumber v = p.getNeededDependenciesRequiredCore();
                if (versionNumber != null && !v.isNewerThan(versionNumber)) continue;
                versionNumber = v;
            }
            return versionNumber;
        }

        public boolean isNeededDependenciesForNewerJenkins() {
            return this.isNeededDependenciesForNewerJenkins(new PluginManager.MetadataCache());
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isNeededDependenciesForNewerJenkins(PluginManager.MetadataCache cache) {
            return cache.of("isNeededDependenciesForNewerJenkins:" + this.name, Boolean.class, () -> {
                for (Plugin p : this.getNeededDependencies()) {
                    if (!p.isForNewerHudson() && !p.isNeededDependenciesForNewerJenkins()) continue;
                    return true;
                }
                return false;
            });
        }

        public boolean isNeededDependenciesCompatibleWithInstalledVersion() {
            return this.isNeededDependenciesCompatibleWithInstalledVersion(new PluginManager.MetadataCache());
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isNeededDependenciesCompatibleWithInstalledVersion(PluginManager.MetadataCache cache) {
            return this.getDependenciesIncompatibleWithInstalledVersion(cache).isEmpty();
        }

        @Restricted(value={NoExternalUse.class})
        public boolean fixesSecurityVulnerabilities() {
            PluginWrapper installed = this.getInstalled();
            if (installed == null) {
                return false;
            }
            boolean allWarningsStillApply = true;
            for (Warning warning : ExtensionList.lookupSingleton(UpdateSiteWarningsMonitor.class).getActivePluginWarningsByPlugin().getOrDefault(installed, Collections.emptyList())) {
                boolean thisWarningApplies = false;
                for (WarningVersionRange range : warning.versionRanges) {
                    if (!range.includes(new VersionNumber(this.version))) continue;
                    thisWarningApplies = true;
                }
                if (thisWarningApplies) continue;
                allWarningsStillApply = false;
            }
            return !allWarningsStillApply;
        }

        @Restricted(value={NoExternalUse.class})
        public List<Plugin> getDependenciesIncompatibleWithInstalledVersion(PluginManager.MetadataCache cache) {
            return cache.of("getDependenciesIncompatibleWithInstalledVersion:" + this.name, List.class, () -> {
                ArrayList<Plugin> incompatiblePlugins = new ArrayList<Plugin>();
                for (Plugin p : this.getNeededDependencies()) {
                    if (p.isCompatibleWithInstalledVersion() && p.isNeededDependenciesCompatibleWithInstalledVersion()) continue;
                    incompatiblePlugins.add(p);
                }
                return incompatiblePlugins;
            });
        }

        public void setIncompatibleParentPlugins(Set<Plugin> incompatibleParentPlugins) {
            this.incompatibleParentPlugins = incompatibleParentPlugins;
        }

        @Restricted(value={NoExternalUse.class})
        public Set<Plugin> getIncompatibleParentPlugins() {
            return this.incompatibleParentPlugins;
        }

        @Restricted(value={NoExternalUse.class})
        public boolean hasIncompatibleParentPlugins() {
            return this.incompatibleParentPlugins != null && !this.incompatibleParentPlugins.isEmpty();
        }

        @Restricted(value={NoExternalUse.class})
        @CheckForNull
        public Set<Warning> getWarnings() {
            UpdateSiteWarningsConfiguration configuration = ExtensionList.lookupSingleton(UpdateSiteWarningsConfiguration.class);
            HashSet<Warning> warnings = new HashSet<Warning>();
            for (Warning warning : configuration.getAllWarnings()) {
                if (configuration.isIgnored(warning) || !warning.isPluginWarning(this.name) || !warning.isRelevantToVersion(new VersionNumber(this.version))) continue;
                warnings.add(warning);
            }
            return warnings;
        }

        public boolean hasCategory(String category) {
            if (this.categories == null) {
                return false;
            }
            return Arrays.asList(this.categories).contains(category);
        }

        public Stream<String> getCategoriesStream() {
            return this.categories != null ? Arrays.stream(this.categories) : Stream.empty();
        }

        @Restricted(value={DoNotUse.class})
        public boolean hasWarnings() {
            return !this.getWarnings().isEmpty();
        }

        @Deprecated
        public void install() {
            this.deploy();
        }

        public Future<UpdateCenter.UpdateCenterJob> deploy() {
            return this.deploy(false);
        }

        public Future<UpdateCenter.UpdateCenterJob> deploy(boolean dynamicLoad) {
            return this.deploy(dynamicLoad, null, null, false);
        }

        @Restricted(value={NoExternalUse.class})
        public Future<UpdateCenter.UpdateCenterJob> deploy(boolean dynamicLoad, @CheckForNull UUID correlationId, @CheckForNull List<PluginWrapper> batch, boolean hasEnabledDependents) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            UpdateCenter uc = Jenkins.get().getUpdateCenter();
            PluginWrapper pw = this.getInstalled();
            for (Plugin dep : this.getNeededDependencies()) {
                UpdateCenter.InstallationJob job = uc.getJob(dep);
                if (job == null || job.status instanceof UpdateCenter.DownloadJob.Failure) {
                    LOGGER.log(Level.INFO, "Adding dependent install of " + dep.name + " for plugin " + this.name);
                    if (pw == null) {
                        dep.deploy(dynamicLoad, null, batch, true);
                        continue;
                    }
                    dep.deploy(dynamicLoad, null, batch, pw.isEnabled());
                    continue;
                }
                LOGGER.log(Level.FINE, "Dependent install of {0} for plugin {1} already added, skipping", new Object[]{dep.name, this.name});
            }
            if (pw != null) {
                Future<UpdateCenter.UpdateCenterJob> enableJob = null;
                if (!pw.isEnabled() && hasEnabledDependents) {
                    UpdateCenter updateCenter = uc;
                    Objects.requireNonNull(updateCenter);
                    UpdateCenter.EnableJob job = updateCenter.new UpdateCenter.EnableJob(UpdateSite.this, null, this, dynamicLoad);
                    job.setCorrelationId(correlationId);
                    enableJob = uc.addJob(job);
                }
                if (pw.getVersionNumber().equals((Object)new VersionNumber(this.version))) {
                    Future<UpdateCenter.UpdateCenterJob> future;
                    if (enableJob != null) {
                        future = enableJob;
                    } else {
                        UpdateCenter updateCenter = uc;
                        Objects.requireNonNull(updateCenter);
                        future = uc.addJob(updateCenter.new UpdateCenter.NoOpJob(UpdateSite.this, null, this));
                    }
                    return future;
                }
            }
            UpdateCenter.InstallationJob job = UpdateSite.this.createInstallationJob(this, uc, dynamicLoad);
            job.setCorrelationId(correlationId);
            job.setBatch(batch);
            return uc.addJob(job);
        }

        public Future<UpdateCenter.UpdateCenterJob> deployBackup() {
            UpdateCenter uc;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            UpdateCenter updateCenter = uc = Jenkins.get().getUpdateCenter();
            Objects.requireNonNull(updateCenter);
            return uc.addJob(updateCenter.new UpdateCenter.PluginDowngradeJob(this, UpdateSite.this, Jenkins.getAuthentication2()));
        }

        @RequirePOST
        public HttpResponse doInstall() throws IOException {
            this.deploy(false);
            return HttpResponses.redirectTo((String)"../..");
        }

        @RequirePOST
        public HttpResponse doInstallNow() throws IOException {
            this.deploy(true);
            return HttpResponses.redirectTo((String)"../..");
        }

        @RequirePOST
        public HttpResponse doDowngrade() throws IOException {
            this.deployBackup();
            return HttpResponses.redirectTo((String)"../..");
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class IssueTracker {
        public final String type;
        public final String viewUrl;
        @CheckForNull
        public final String reportUrl;

        public IssueTracker(@NonNull String type, @NonNull String viewUrl, @CheckForNull String reportUrl) {
            this.type = type;
            this.viewUrl = viewUrl;
            this.reportUrl = reportUrl;
        }

        private static IssueTracker createFromJSONObject(Object o) {
            JSONObject jsonObject;
            if (o instanceof JSONObject && (jsonObject = (JSONObject)o).has("type") && jsonObject.has("viewUrl") && jsonObject.has("reportUrl")) {
                return new IssueTracker(jsonObject.getString("type"), jsonObject.getString("viewUrl"), jsonObject.getString("reportUrl"));
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public final class Warning {
        @NonNull
        public WarningType type;
        @Exported
        @NonNull
        public final String id;
        @Exported
        @NonNull
        public final String component;
        @Exported
        @NonNull
        public final String message;
        @Exported
        @NonNull
        public final String url;
        @Exported
        @NonNull
        public final List<WarningVersionRange> versionRanges;

        @Restricted(value={NoExternalUse.class})
        public Warning(JSONObject o) {
            try {
                this.type = WarningType.valueOf(o.getString("type").toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException ex) {
                this.type = WarningType.UNKNOWN;
            }
            this.id = o.getString("id");
            this.component = Util.intern(o.getString("name"));
            this.message = o.getString("message");
            this.url = o.getString("url");
            if (o.has("versions")) {
                JSONArray versions = o.getJSONArray("versions");
                ArrayList<WarningVersionRange> ranges = new ArrayList<WarningVersionRange>(versions.size());
                for (int i = 0; i < versions.size(); ++i) {
                    WarningVersionRange range = new WarningVersionRange(versions.getJSONObject(i));
                    ranges.add(range);
                }
                this.versionRanges = Collections.unmodifiableList(ranges);
            } else {
                this.versionRanges = Collections.emptyList();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Warning)) {
                return false;
            }
            Warning warning = (Warning)o;
            return this.id.equals(warning.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean isPluginWarning(@NonNull String pluginName) {
            return this.type == WarningType.PLUGIN && pluginName.equals(this.component);
        }

        public boolean isRelevant() {
            switch (this.type.ordinal()) {
                case 0: {
                    VersionNumber current = Jenkins.getVersion();
                    return this.isRelevantToVersion(current);
                }
                case 1: {
                    PluginWrapper plugin = Jenkins.get().getPluginManager().getPlugin(this.component);
                    if (plugin == null) {
                        return false;
                    }
                    VersionNumber currentCore = plugin.getVersionNumber();
                    return this.isRelevantToVersion(currentCore);
                }
            }
            return false;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="TODO needs triage")
        public Boolean isFixable() {
            Data data = UpdateSite.this.data;
            if (data == null) {
                return null;
            }
            switch (this.type.ordinal()) {
                case 0: {
                    Entry core = data.core;
                    if (core == null) {
                        return null;
                    }
                    VersionNumber latestCoreVersion = new VersionNumber(core.version);
                    return !this.isRelevantToVersion(latestCoreVersion);
                }
                case 1: {
                    Entry plugin = data.plugins.get(this.component);
                    if (plugin == null) {
                        return null;
                    }
                    VersionNumber latestCoreVersion = new VersionNumber(plugin.version);
                    return !this.isRelevantToVersion(latestCoreVersion);
                }
            }
            return null;
        }

        public boolean isRelevantToVersion(@NonNull VersionNumber version) {
            if (this.versionRanges.isEmpty()) {
                return true;
            }
            for (WarningVersionRange range : this.versionRanges) {
                if (!range.includes(version)) continue;
                return true;
            }
            return false;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static enum WarningType {
        CORE,
        PLUGIN,
        UNKNOWN;

    }

    @Restricted(value={NoExternalUse.class})
    public static final class Deprecation {
        public final String url;

        public Deprecation(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Deprecation that = (Deprecation)o;
            return Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(this.url);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WarningVersionRange {
        @Nullable
        public final String name;
        @Nullable
        public final String firstVersion;
        @Nullable
        public final String lastVersion;
        @NonNull
        private final Pattern pattern;

        public WarningVersionRange(JSONObject o) {
            Pattern p;
            this.name = Util.fixEmpty(o.optString("name"));
            this.firstVersion = Util.intern(Util.fixEmpty(o.optString("firstVersion")));
            this.lastVersion = Util.intern(Util.fixEmpty(o.optString("lastVersion")));
            try {
                p = Pattern.compile(o.getString("pattern"));
            }
            catch (PatternSyntaxException ex) {
                LOGGER.log(Level.WARNING, "Failed to compile pattern '" + o.getString("pattern") + "', using '.*' instead", ex);
                p = Pattern.compile(".*");
            }
            this.pattern = p;
        }

        public boolean includes(VersionNumber number) {
            return this.pattern.matcher(number.toString()).matches();
        }
    }

    @ExportedBean
    public static class Entry {
        @Exported
        public final String sourceId;
        @Exported
        public final String name;
        @Exported
        public final String version;
        @Exported
        public final String url;
        private final Long size;
        @Restricted(value={NoExternalUse.class})
        String sha1;
        @Restricted(value={NoExternalUse.class})
        String sha256;
        @Restricted(value={NoExternalUse.class})
        String sha512;

        public Entry(String sourceId, JSONObject o) {
            this(sourceId, o, null);
        }

        Entry(String sourceId, JSONObject o, String baseURL) {
            this.sourceId = sourceId;
            this.name = Util.intern(o.getString("name"));
            this.version = Util.intern(o.getString("version"));
            this.sha1 = Util.fixEmptyAndTrim(o.optString("sha1"));
            this.sha256 = Util.fixEmptyAndTrim(o.optString("sha256"));
            this.sha512 = Util.fixEmptyAndTrim(o.optString("sha512"));
            Long fileSize = null;
            if (o.has("size")) {
                fileSize = o.getLong("size");
            }
            this.size = fileSize;
            String url = o.getString("url");
            if (!URI.create(url).isAbsolute()) {
                if (baseURL == null) {
                    throw new IllegalArgumentException("Cannot resolve " + url + " without a base URL");
                }
                url = URI.create(baseURL).resolve(url).toString();
            }
            this.url = url;
        }

        public String getSha1() {
            return this.sha1;
        }

        public String getSha256() {
            return this.sha256;
        }

        public String getSha512() {
            return this.sha512;
        }

        public boolean isNewerThan(String currentVersion) {
            try {
                return new VersionNumber(currentVersion).compareTo(new VersionNumber(this.version)) < 0;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public Api getApi() {
            return new Api(this);
        }

        @Restricted(value={NoExternalUse.class})
        public Long getFileSize() {
            return this.size;
        }
    }
}

