/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConstantThrowable;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.websocket.core.OutgoingEntry;
import org.eclipse.jetty.websocket.core.OutgoingFrames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketFlusher
implements OutgoingFrames {
    private static final Throwable SENTINEL_CLOSE_EXCEPTION = new ConstantThrowable("Closed");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AutoLock _lock = new AutoLock();
    private final Queue<OutgoingEntry> _entries = new ArrayDeque<OutgoingEntry>();
    private final IteratingCallback _flusher = new Flusher();
    private Throwable _failure;

    protected abstract boolean onFrame(OutgoingEntry var1, boolean var2);

    protected void onCompleteFailure(Throwable cause) {
    }

    @Override
    public final void sendFrame(OutgoingEntry entry) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Queuing {}", (Object)entry);
        }
        Throwable failure = null;
        try (AutoLock ignored = this._lock.lock();){
            if (this._failure == null) {
                this._entries.add(entry);
            } else {
                failure = this._failure;
            }
        }
        if (failure == null) {
            this._flusher.iterate();
        } else {
            this.notifyCallbackFailure(entry, failure);
        }
    }

    public void closeFlusher() {
        this.failFlusher(SENTINEL_CLOSE_EXCEPTION);
    }

    public void failFlusher(Throwable t) {
        boolean failed = false;
        try (AutoLock ignored = this._lock.lock();){
            if (this._failure == null) {
                this._failure = t;
                failed = true;
            } else {
                this._failure.addSuppressed(t);
            }
        }
        if (failed) {
            this._flusher.abort(t);
        }
    }

    private void notifyCallbackSuccess(OutgoingEntry entry) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("notifyCallbackSuccess {}", (Object)entry);
        }
        try {
            entry.getCallback().succeeded();
        }
        catch (Throwable x) {
            this.log.warn("Exception while notifying success of entry {}", (Object)entry, (Object)x);
        }
    }

    private void notifyCallbackFailure(OutgoingEntry entry, Throwable failure) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("notifyCallbackFailure {} {}", (Object)entry, (Object)failure.toString());
        }
        try {
            entry.getCallback().failed(failure);
        }
        catch (Throwable x) {
            this.log.warn("Exception while notifying failure of entry {}", (Object)entry, (Object)x);
        }
    }

    private class Flusher
    extends IteratingCallback
    implements Callback {
        private boolean _completed = false;
        private OutgoingEntry _current;

        private Flusher() {
        }

        @Override
        protected IteratingCallback.Action process() throws Throwable {
            boolean first = false;
            try (AutoLock ignored = WebSocketFlusher.this._lock.lock();){
                if (WebSocketFlusher.this._failure != null) {
                    throw WebSocketFlusher.this._failure;
                }
                if (this._current == null) {
                    first = true;
                    this._current = WebSocketFlusher.this._entries.poll();
                }
            }
            if (this._current == null) {
                return IteratingCallback.Action.IDLE;
            }
            if (WebSocketFlusher.this.log.isDebugEnabled()) {
                WebSocketFlusher.this.log.debug("onFrame {}", (Object)this._current);
            }
            this._completed = WebSocketFlusher.this.onFrame(new OutgoingEntry.Builder(this._current).callback(this).build(), first);
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        protected void onSuccess() {
            if (this._completed) {
                WebSocketFlusher.this.notifyCallbackSuccess(this._current);
                this._current = null;
            }
        }

        @Override
        protected void onCompleteFailure(Throwable t) {
            ArrayList<OutgoingEntry> entries;
            if (WebSocketFlusher.this.log.isDebugEnabled()) {
                WebSocketFlusher.this.log.debug("onCompleteFailure {}", (Object)t.toString());
            }
            try (AutoLock ignored = WebSocketFlusher.this._lock.lock();){
                if (WebSocketFlusher.this._failure == null) {
                    WebSocketFlusher.this._failure = t;
                }
                entries = new ArrayList<OutgoingEntry>(WebSocketFlusher.this._entries);
                WebSocketFlusher.this._entries.clear();
            }
            if (this._current != null) {
                WebSocketFlusher.this.notifyCallbackFailure(this._current, t);
                this._current = null;
            }
            for (OutgoingEntry entry : entries) {
                WebSocketFlusher.this.notifyCallbackFailure(entry, t);
            }
            WebSocketFlusher.this.onCompleteFailure(t);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            if (this._current == null) {
                return Invocable.InvocationType.NON_BLOCKING;
            }
            return this._current.getCallback().getInvocationType();
        }
    }
}

