/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;

public class MapToDateMorpher
extends AbstractObjectMorpher {
    private Date defaultValue;

    public MapToDateMorpher() {
    }

    public MapToDateMorpher(Date defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapToDateMorpher)) {
            return false;
        }
        MapToDateMorpher other = (MapToDateMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public Date getDefaultValue() {
        return (Date)this.defaultValue.clone();
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return (Date)value;
        }
        if (!this.supports(value.getClass())) {
            throw new MorphException(String.valueOf(value.getClass()) + " is not supported");
        }
        Map map = (Map)value;
        if (map.isEmpty()) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("Unable to parse the date " + String.valueOf(value));
        }
        Calendar c = Calendar.getInstance();
        c.set(1, this.getValue(map, "year"));
        c.set(2, this.getValue(map, "month"));
        c.set(5, this.getValue(map, "day"));
        c.set(11, this.getValue(map, "hour"));
        c.set(12, this.getValue(map, "minutes"));
        c.set(13, this.getValue(map, "seconds"));
        c.set(14, this.getValue(map, "milliseconds"));
        return c.getTime();
    }

    @Override
    public Class morphsTo() {
        return Date.class;
    }

    public void setDefaultValue(Date defaultValue) {
        this.defaultValue = (Date)defaultValue.clone();
    }

    @Override
    public boolean supports(Class clazz) {
        return clazz != null && Map.class.isAssignableFrom(clazz);
    }

    private int getValue(Map map, String key) {
        Object value = map.get(key);
        if (value == null || !(value instanceof Number)) {
            return 0;
        }
        Number n = (Number)value;
        return n.intValue();
    }
}

