/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

abstract class URLish {
    private URLish() {
    }

    @CheckForNull
    abstract URL toURL() throws MalformedURLException;

    @NonNull
    static URLish from(final @NonNull URL url) {
        return new URLish(){

            @Override
            @NonNull
            URL toURL() {
                return url;
            }
        };
    }

    @NonNull
    static URLish from(final @NonNull File f) {
        return new URLish(){

            @Override
            URL toURL() throws MalformedURLException {
                if (f.exists()) {
                    return f.toURI().toURL();
                }
                return null;
            }
        };
    }
}

