/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.jmx;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.jmx.Handler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;

@ManagedObject(value="ContextHandler mbean wrapper")
public class ContextHandlerMBean
extends Handler.AbstractMBean {
    public ContextHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    @Override
    public ContextHandler getManagedObject() {
        return (ContextHandler)super.getManagedObject();
    }

    @Override
    public String getObjectNameBasis() {
        return this.getManagedObject().getDisplayName();
    }

    @Override
    public String getObjectContextBasis() {
        ContextHandler contextHandler = this.getManagedObject();
        String ctxPath = contextHandler.getContextPath();
        if (StringUtil.isBlank(ctxPath) || "/".equals(ctxPath)) {
            ctxPath = "ROOT";
        }
        Object context = ctxPath.replaceAll("/", "_");
        List<String> vHosts = contextHandler.getVirtualHosts();
        if (vHosts != null && !vHosts.isEmpty()) {
            context = (String)context + "@" + vHosts.get(0);
        }
        return context;
    }

    @ManagedAttribute(value="Map of context attributes")
    public Map<String, String> getContextAttributes() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        ContextHandler.ScopedContext context = this.getManagedObject().getContext();
        for (String name : context.getAttributeNameSet()) {
            map.put(name, String.valueOf(context.getAttribute(name)));
        }
        return map;
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") Object value) {
        this.getManagedObject().getContext().setAttribute(name, value);
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") String value) {
        this.getManagedObject().getContext().setAttribute(name, value);
    }

    @ManagedOperation(value="Remove context attribute", impact="ACTION")
    public void removeContextAttribute(@Name(value="name", description="attribute name") String name) {
        this.getManagedObject().getContext().removeAttribute(name);
    }
}

