/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.security.csp.AdvancedConfigurationDescriptor;
import jenkins.security.csp.Contributor;
import jenkins.security.csp.CspBuilder;
import jenkins.security.csp.CspHeader;
import jenkins.security.csp.CspHeaderDecider;
import jenkins.security.csp.impl.CspConfiguration;
import jenkins.telemetry.Telemetry;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class ContentSecurityPolicy
extends Telemetry {
    private static final Logger LOGGER = Logger.getLogger(ContentSecurityPolicy.class.getName());

    @Override
    @NonNull
    public String getDisplayName() {
        return "Content Security Policy";
    }

    @Override
    @NonNull
    public LocalDate getStart() {
        return LocalDate.of(2025, 12, 1);
    }

    @Override
    @NonNull
    public LocalDate getEnd() {
        return LocalDate.of(2026, 6, 1);
    }

    @Override
    public JSONObject createContent() {
        JSONObject data = new JSONObject();
        data.put("enforce", (Object)ExtensionList.lookupSingleton(CspConfiguration.class).isEnforce());
        Optional<CspHeaderDecider> decider = CspHeaderDecider.getCurrentDecider();
        data.put("decider", decider.map(Object::getClass).map(Class::getName).orElse(null));
        data.put("header", decider.map(CspHeaderDecider::decide).filter(Optional::isPresent).map(Optional::get).map(CspHeader::getHeaderName).orElse(null));
        TreeSet contributors = new TreeSet();
        ExtensionList.lookup(Contributor.class).stream().map((Function<Contributor, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Ljenkins/security/csp/Contributor;)Ljava/lang/Class;)()).map(Class::getName).forEach(contributors::add);
        data.put("contributors", contributors);
        TreeSet configurations = new TreeSet();
        ExtensionList.lookup(AdvancedConfigurationDescriptor.class).stream().map(Object::getClass).map(Class::getName).forEach(configurations::add);
        data.put("configurations", configurations);
        try {
            Map<String, Map> directivesSize = new CspBuilder().withDefaultContributions().getMergedDirectives().stream().map(d -> Map.entry(d.name(), Map.of("entries", d.values().size(), "chars", String.join((CharSequence)" ", d.values()).length()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            data.put("directivesSize", directivesSize);
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.FINE, "Error during directive processing", ex);
        }
        data.put("components", this.buildComponentInformation());
        return data;
    }
}

