/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.node_monitors.AbstractDiskSpaceMonitor;
import hudson.node_monitors.DiskSpaceMonitorDescriptor;
import hudson.node_monitors.DiskSpaceMonitorNodeProperty;
import hudson.node_monitors.Messages;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class TemporarySpaceMonitor
extends AbstractDiskSpaceMonitor {
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="for backward compatibility")
    public static DiskSpaceMonitorDescriptor DESCRIPTOR;

    @DataBoundConstructor
    public TemporarySpaceMonitor(String freeSpaceThreshold) throws ParseException {
        super(freeSpaceThreshold);
    }

    public TemporarySpaceMonitor() {
    }

    @Override
    public long getThresholdBytes(Computer c) {
        DiskSpaceMonitorNodeProperty nodeProperty;
        Node node = c.getNode();
        if (node != null && (nodeProperty = node.getNodeProperty(DiskSpaceMonitorNodeProperty.class)) != null) {
            try {
                return DiskSpaceMonitorDescriptor.DiskSpace.parse((String)nodeProperty.getFreeTempSpaceThreshold()).size;
            }
            catch (ParseException e) {
                return this.getThresholdBytes();
            }
        }
        return this.getThresholdBytes();
    }

    @Override
    protected long getWarningThresholdBytes(Computer c) {
        DiskSpaceMonitorNodeProperty nodeProperty;
        Node node = c.getNode();
        if (node != null && (nodeProperty = node.getNodeProperty(DiskSpaceMonitorNodeProperty.class)) != null) {
            try {
                return DiskSpaceMonitorDescriptor.DiskSpace.parse((String)nodeProperty.getFreeTempSpaceWarningThreshold()).size;
            }
            catch (ParseException e) {
                return this.getWarningThresholdBytes();
            }
        }
        return this.getWarningThresholdBytes();
    }

    public DiskSpaceMonitorDescriptor.DiskSpace getFreeSpace(Computer c) {
        DiskSpaceMonitorDescriptor descriptor = (DiskSpaceMonitorDescriptor)Jenkins.get().getDescriptor(TemporarySpaceMonitor.class);
        return descriptor != null ? (DiskSpaceMonitorDescriptor.DiskSpace)descriptor.get(c) : null;
    }

    @Override
    public String getColumnCaption() {
        return Jenkins.get().hasPermission(Jenkins.ADMINISTER) ? super.getColumnCaption() : null;
    }

    protected static final class GetTempSpace
    extends MasterToSlaveFileCallable<DiskSpaceMonitorDescriptor.DiskSpace> {
        private static final long serialVersionUID = 1L;

        protected GetTempSpace() {
        }

        @Override
        public DiskSpaceMonitorDescriptor.DiskSpace invoke(File f, VirtualChannel channel) throws IOException {
            f = new File(System.getProperty("java.io.tmpdir"));
            long s = f.getUsableSpace();
            if (s <= 0L) {
                return null;
            }
            DiskSpaceMonitorDescriptor.DiskSpace ds = new DiskSpaceMonitorDescriptor.DiskSpace(f.getCanonicalPath(), s);
            ds.setTotalSize(f.getTotalSpace());
            return ds;
        }
    }

    @Extension
    @Symbol(value={"tmpSpace"})
    public static class DescriptorImpl
    extends DiskSpaceMonitorDescriptor {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.TemporarySpaceMonitor_DisplayName();
        }

        @Override
        protected Callable<DiskSpaceMonitorDescriptor.DiskSpace, IOException> createCallable(Computer c) {
            Node node = c.getNode();
            if (node == null) {
                return null;
            }
            FilePath p = node.getRootPath();
            if (p == null) {
                return null;
            }
            return p.asCallableWith(new GetTempSpace());
        }
    }
}

