/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ObjectInputStreamEx;
import hudson.remoting.ProxyException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;

public abstract class Command
implements Serializable {
    @CheckForNull
    final Exception createdAt;
    private static final long serialVersionUID = 1L;

    Command() {
        this(true);
    }

    Command(Channel channel, @CheckForNull Throwable cause) {
        this.createdAt = new Source((Throwable)(cause != null ? new ProxyException(cause) : null));
    }

    Command(boolean recordCreatedAt) {
        this.createdAt = recordCreatedAt ? new Source() : null;
    }

    abstract void execute(Channel var1) throws ExecutionException;

    final void chainCause(@CheckForNull Throwable initCause) {
        if (this.createdAt != null && initCause != null) {
            this.createdAt.initCause(initCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTo(Channel channel, ObjectOutputStream oos) throws IOException {
        Channel old = Channel.setCurrent(channel);
        try {
            oos.writeObject(this);
        }
        finally {
            Channel.setCurrent(old);
        }
    }

    public static Command readFrom(@NonNull Channel channel, @NonNull byte[] payload) throws IOException, ClassNotFoundException {
        return Command.readFrom(channel, new ByteArrayInputStream(payload), payload.length);
    }

    static Command readFrom(@NonNull Channel channel, @NonNull InputStream istream, int payloadSize) throws IOException, ClassNotFoundException {
        Command cmd = Command.readFromObjectStream(channel, new ObjectInputStreamEx(istream, channel.baseClassLoader, channel.classFilter));
        channel.notifyRead(cmd, payloadSize);
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"}, justification="Used for sending commands between authorized agent and server. Class filtering is done through JEP-200.")
    static Command readFromObjectStream(Channel channel, ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Channel old = Channel.setCurrent(channel);
        try {
            Command command = (Command)ois.readObject();
            return command;
        }
        finally {
            Channel.setCurrent(old);
        }
    }

    @CheckForNull
    public Throwable getCreationStackTrace() {
        return this.createdAt;
    }

    public abstract String toString();

    private final class Source
    extends Exception {
        private static final long serialVersionUID = 1L;

        public Source() {
        }

        private Source(Throwable cause) {
            super(cause);
        }

        @Override
        public String toString() {
            return "Command " + String.valueOf(Command.this) + " created at";
        }
    }
}

