/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.util.FormValidation;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.diagnostics.RootUrlNotSetMonitor;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.model.identity.InstanceIdentityProvider;
import jenkins.security.Messages;
import jenkins.util.UrlHelper;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

@Extension(ordinal=199.0)
@Restricted(value={Beta.class})
@Symbol(value={"resourceRoot"})
public final class ResourceDomainConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(ResourceDomainConfiguration.class.getName());
    private String url;

    @Restricted(value={NoExternalUse.class})
    public ResourceDomainConfiguration() {
        this.load();
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckUrl(@QueryParameter(value="url") String resourceRootUrlString) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this.checkUrl(resourceRootUrlString, true);
    }

    private FormValidation checkUrl(String resourceRootUrlString, boolean allowOnlineIdentityCheck) {
        String currentRequestHost;
        URL resourceRootUrl;
        String jenkinsRootUrlString = JenkinsLocationConfiguration.get().getUrl();
        if (ExtensionList.lookupSingleton(RootUrlNotSetMonitor.class).isActivated() || jenkinsRootUrlString == null) {
            return FormValidation.warning(Messages.ResourceDomainConfiguration_NeedsRootURL());
        }
        if ((resourceRootUrlString = Util.fixEmptyAndTrim((String)resourceRootUrlString)) == null) {
            return FormValidation.ok(Messages.ResourceDomainConfiguration_Empty());
        }
        if (!UrlHelper.isValidRootUrl((String)resourceRootUrlString)) {
            return FormValidation.error(Messages.ResourceDomainConfiguration_Invalid());
        }
        if (!((String)resourceRootUrlString).endsWith("/")) {
            resourceRootUrlString = (String)resourceRootUrlString + "/";
        }
        try {
            resourceRootUrl = new URI((String)resourceRootUrlString).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            return FormValidation.error(Messages.ResourceDomainConfiguration_Invalid());
        }
        String resourceRootUrlHost = resourceRootUrl.getHost();
        try {
            String jenkinsRootUrlHost = new URI(jenkinsRootUrlString).getHost();
            if (jenkinsRootUrlHost.equals(resourceRootUrlHost)) {
                return FormValidation.error(Messages.ResourceDomainConfiguration_SameAsJenkinsRoot());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.CONFIG, "Failed to create URL from the existing Jenkins URL", ex);
            return FormValidation.error(Messages.ResourceDomainConfiguration_InvalidRootURL(ex.getMessage()));
        }
        StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
        if (currentRequest != null && (currentRequestHost = currentRequest.getServerName()).equals(resourceRootUrlHost)) {
            return FormValidation.error(Messages.ResourceDomainConfiguration_SameAsCurrent());
        }
        if (!allowOnlineIdentityCheck) {
            return FormValidation.ok();
        }
        try {
            URLConnection urlConnection = new URI((String)resourceRootUrlString + "instance-identity/").toURL().openConnection();
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                int responseCode = httpURLConnection.getResponseCode();
                if (responseCode == 200) {
                    String identityHeader = urlConnection.getHeaderField("X-Instance-Identity");
                    if (identityHeader == null) {
                        return FormValidation.warning(Messages.ResourceDomainConfiguration_NotJenkins());
                    }
                    RSAPublicKey publicKey = InstanceIdentityProvider.RSA.getPublicKey();
                    if (publicKey != null) {
                        String identity = Base64.getEncoder().encodeToString(publicKey.getEncoded());
                        if (identity.equals(identityHeader)) {
                            return FormValidation.ok(Messages.ResourceDomainConfiguration_ThisJenkins());
                        }
                        return FormValidation.warning(Messages.ResourceDomainConfiguration_OtherJenkins());
                    }
                    return FormValidation.warning(Messages.ResourceDomainConfiguration_SomeJenkins());
                }
                String responseMessage = httpURLConnection.getResponseMessage();
                if (responseCode == 404) {
                    String responseBody = String.join((CharSequence)"", IOUtils.readLines((InputStream)httpURLConnection.getErrorStream(), (Charset)StandardCharsets.UTF_8));
                    if (responseMessage.contains("Jenkins serves only static files on this domain.") || responseBody.contains("Jenkins serves only static files on this domain.")) {
                        return FormValidation.ok(Messages.ResourceDomainConfiguration_ResourceResponse());
                    }
                }
                return FormValidation.error(Messages.ResourceDomainConfiguration_FailedIdentityCheck(responseCode, responseMessage));
            }
            return FormValidation.error(Messages.ResourceDomainConfiguration_Invalid());
        }
        catch (MalformedURLException | URISyntaxException ex) {
            LOGGER.log(Level.FINE, "MalformedURLException occurred during instance identity check for " + (String)resourceRootUrlString, ex);
            return FormValidation.error(Messages.ResourceDomainConfiguration_Exception(ex.getMessage()));
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "IOException occurred during instance identity check for " + (String)resourceRootUrlString, ex);
            return FormValidation.warning(Messages.ResourceDomainConfiguration_IOException(ex.getMessage()));
        }
    }

    @CheckForNull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@CheckForNull String url) {
        if (this.checkUrl((String)url, (boolean)false).kind == FormValidation.Kind.OK) {
            if ((url = Util.fixEmpty((String)url)) != null && !((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            this.url = url;
            this.save();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean isResourceRequest(HttpServletRequest req) {
        if (!ResourceDomainConfiguration.isResourceDomainConfigured()) {
            return false;
        }
        String resourceRootUrl = ResourceDomainConfiguration.get().getUrl();
        try {
            int requestedPort;
            URL url = new URL(resourceRootUrl);
            String resourceRootHost = url.getHost();
            if (!resourceRootHost.equalsIgnoreCase(req.getServerName())) {
                return false;
            }
            int resourceRootPort = url.getPort();
            if (resourceRootPort == -1) {
                resourceRootPort = url.getDefaultPort();
            }
            if ((requestedPort = req.getServerPort()) != resourceRootPort) {
                return false;
            }
        }
        catch (MalformedURLException ex) {
            return false;
        }
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean isResourceDomainConfigured() {
        String resourceRootUrl = ResourceDomainConfiguration.get().getUrl();
        if (resourceRootUrl == null || resourceRootUrl.isEmpty()) {
            return false;
        }
        return Util.nullify(JenkinsLocationConfiguration.get().getUrl()) != null;
    }

    public static ResourceDomainConfiguration get() {
        return ExtensionList.lookupSingleton(ResourceDomainConfiguration.class);
    }
}

