/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;

public class CreatorNegotiator
extends WebSocketNegotiator.AbstractNegotiator {
    private final WebSocketCreator creator;
    private final FrameHandlerFactory factory;

    public CreatorNegotiator(WebSocketCreator creator, FrameHandlerFactory factory) {
        this(creator, factory, null);
    }

    public CreatorNegotiator(WebSocketCreator creator, FrameHandlerFactory factory, Configuration.Customizer customizer) {
        super(customizer);
        this.creator = creator;
        this.factory = factory;
    }

    public WebSocketCreator getWebSocketCreator() {
        return this.creator;
    }

    @Override
    public FrameHandler negotiate(ServerUpgradeRequest request, ServerUpgradeResponse response, Callback callback) {
        Object websocketPojo;
        Context context = request.getContext();
        try {
            AtomicReference result = new AtomicReference();
            context.run(() -> result.set(this.creator.createWebSocket(request, response, callback)));
            websocketPojo = result.get();
        }
        catch (Throwable t) {
            callback.failed(t);
            return null;
        }
        if (websocketPojo == null) {
            return null;
        }
        FrameHandler frameHandler = this.factory.newFrameHandler(websocketPojo, request, response);
        if (frameHandler == null) {
            callback.failed(new IllegalStateException("No WebSocket FrameHandler was created"));
        }
        return frameHandler;
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s,%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.creator, this.factory);
    }
}

