/*
 * Decompiled with CFR 0.152.
 */
package jenkins.tools;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.RestrictedSince;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.security.Permission;
import hudson.util.FormApply;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.management.Messages;
import jenkins.model.Jenkins;
import jenkins.tools.ToolConfigurationCategory;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Extension(ordinal=2.147483427E9)
@Restricted(value={NoExternalUse.class})
public class GlobalToolConfiguration
extends ManagementLink {
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.301")
    public static final Predicate<Descriptor> FILTER = input -> input.getCategory() instanceof ToolConfigurationCategory;
    private static final Logger LOGGER = Logger.getLogger(GlobalToolConfiguration.class.getName());

    @Override
    public String getIconFileName() {
        return "symbol-hammer";
    }

    @Override
    public String getDisplayName() {
        return Messages.ConfigureTools_DisplayName();
    }

    @Override
    public String getDescription() {
        return Messages.ConfigureTools_Description();
    }

    @Override
    public String getUrlName() {
        return "configureTools";
    }

    @Override
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    @Override
    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    @POST
    public synchronized void doConfigure(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        boolean result = this.configure(req, req.getSubmittedForm());
        LOGGER.log(Level.FINE, "tools saved: " + result);
        FormApply.success(req.getContextPath() + "/manage").generateResponse(req, rsp, null);
    }

    private boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException, IOException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        boolean result = true;
        for (Descriptor d : Functions.getSortedDescriptorsForGlobalConfigByDescriptor(FILTER)) {
            result &= this.configureDescriptor(req, json, d);
        }
        j.save();
        return result;
    }

    private boolean configureDescriptor(StaplerRequest2 req, JSONObject json, Descriptor<?> d) throws Descriptor.FormException {
        String name = d.getJsonSafeClassName();
        JSONObject js = json.has(name) ? json.getJSONObject(name) : new JSONObject();
        json.putAll((Map)js);
        return d.configure(req, js);
    }
}

