/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.xml;

import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.expression.CompositeExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;
import org.apache.commons.jelly.expression.xpath.XPathExpression;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.jelly.tags.xml.AttributeTag;
import org.apache.commons.jelly.tags.xml.CommentTag;
import org.apache.commons.jelly.tags.xml.CopyOfTag;
import org.apache.commons.jelly.tags.xml.CopyTag;
import org.apache.commons.jelly.tags.xml.DoctypeTag;
import org.apache.commons.jelly.tags.xml.ElementTag;
import org.apache.commons.jelly.tags.xml.ExprTag;
import org.apache.commons.jelly.tags.xml.ForEachTag;
import org.apache.commons.jelly.tags.xml.IfTag;
import org.apache.commons.jelly.tags.xml.ParamTag;
import org.apache.commons.jelly.tags.xml.ParseTag;
import org.apache.commons.jelly.tags.xml.ReplaceNamespaceTag;
import org.apache.commons.jelly.tags.xml.SetTag;
import org.apache.commons.jelly.tags.xml.SortTag;
import org.apache.commons.jelly.tags.xml.TransformTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLTagLibrary
extends TagLibrary {
    private Log log = LogFactory.getLog(XMLTagLibrary.class);
    private JexlExpressionFactory jexlFactory;

    public XMLTagLibrary() {
        this.registerTag("out", ExprTag.class);
        this.registerTag("if", IfTag.class);
        this.registerTag("forEach", ForEachTag.class);
        this.registerTag("parse", ParseTag.class);
        this.registerTag("set", SetTag.class);
        this.registerTag("transform", TransformTag.class);
        this.registerTag("param", ParamTag.class);
        this.registerTag("expr", ExprTag.class);
        this.registerTag("element", ElementTag.class);
        this.registerTag("attribute", AttributeTag.class);
        this.registerTag("replaceNamespace", ReplaceNamespaceTag.class);
        this.registerTag("copy", CopyTag.class);
        this.registerTag("copyOf", CopyOfTag.class);
        this.registerTag("comment", CommentTag.class);
        this.registerTag("doctype", DoctypeTag.class);
        this.registerTag("sort", SortTag.class);
        this.jexlFactory = new JexlExpressionFactory();
    }

    public Expression createExpression(ExpressionFactory factory, TagScript tagScript, String attributeName, String attributeValue) throws JellyException {
        if (attributeName.equals("select") || attributeName.equals("sort")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Parsing XPath expression: " + attributeValue));
            }
            Expression xpathExpr = this.createXPathTextExpression(attributeValue);
            return new XPathExpression(attributeValue, xpathExpr, tagScript);
        }
        return super.createExpression(factory, tagScript, attributeName, attributeValue);
    }

    protected Expression createXPathTextExpression(String exprText) throws JellyException {
        return CompositeExpression.parse((String)exprText, (ExpressionFactory)this.jexlFactory);
    }
}

