/*
 * Decompiled with CFR 0.152.
 */
package jenkins.views;

import hudson.ExtensionComponent;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.RootAction;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.views.JenkinsHeader;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class Header
implements ExtensionPoint {
    public boolean isAvailable() {
        return this.isCompatible() && this.isEnabled();
    }

    public abstract boolean isCompatible();

    public abstract boolean isEnabled();

    @Restricted(value={NoExternalUse.class})
    public static Header get() {
        Optional<Header> header = ExtensionList.lookup(Header.class).stream().filter(Header::isAvailable).findFirst();
        return header.orElseGet(JenkinsHeader::new);
    }

    @Restricted(value={NoExternalUse.class})
    public List<Action> getActions() {
        Map<String, Double> rootActionsOrdinal = ExtensionList.lookup(RootAction.class).getComponents().stream().collect(Collectors.toMap(c -> ((RootAction)c.getInstance()).getClass().getName(), ExtensionComponent::ordinal));
        return Jenkins.get().getActions().stream().filter(e -> {
            IconSpec is;
            return e.getIconFileName() != null || e instanceof IconSpec && (is = (IconSpec)((Object)e)).getIconClassName() != null || Header.hasLegacyView(e);
        }).sorted(Comparator.comparingDouble(a -> rootActionsOrdinal.getOrDefault(a.getClass().getName(), (Double)Double.MAX_VALUE)).reversed()).toList();
    }

    private static boolean hasLegacyView(Action action) {
        try {
            return Functions.hasView(action, "action");
        }
        catch (IOException ignored) {
            return false;
        }
    }
}

