/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.init.Initializer;
import hudson.util.PluginServletFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.CompatibleFilter;

public interface HttpServletFilter
extends ExtensionPoint {
    public boolean handle(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    @Restricted(value={DoNotUse.class})
    @Initializer
    public static void register() throws ServletException {
        PluginServletFilter.addFilter((Filter)new CompatibleFilter(){

            public void doFilter(ServletRequest req, ServletResponse rsp, FilterChain chain) throws IOException, ServletException {
                if (req instanceof HttpServletRequest && rsp instanceof HttpServletResponse) {
                    for (HttpServletFilter filter : ExtensionList.lookup(HttpServletFilter.class)) {
                        if (!filter.handle((HttpServletRequest)req, (HttpServletResponse)rsp)) continue;
                        return;
                    }
                }
                chain.doFilter(req, rsp);
            }

            public void init(FilterConfig filterConfig) {
            }

            public void destroy() {
            }
        });
    }
}

