/*
 * Decompiled with CFR 0.152.
 */
package jenkins.tasks.filters.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jenkins.tasks.filters.EnvVarsFilterLocalRule;
import jenkins.tasks.filters.EnvVarsFilterLocalRuleDescriptor;
import jenkins.tasks.filters.EnvVarsFilterRuleContext;
import jenkins.tasks.filters.EnvVarsFilterableBuilder;
import jenkins.tasks.filters.impl.Messages;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Restricted(value={NoExternalUse.class})
public class RetainVariablesLocalRule
implements EnvVarsFilterLocalRule {
    private static final List<String> CHARACTERISTIC_ENV_VARS = Arrays.asList("jenkins_server_cookie", "hudson_server_cookie", "job_name", "job_base_name", "build_number", "build_id", "build_tag");
    private String variables = "";
    private boolean retainCharacteristicEnvVars = true;
    private ProcessVariablesHandling processVariablesHandling = ProcessVariablesHandling.RESET;

    @DataBoundConstructor
    public RetainVariablesLocalRule() {
    }

    @DataBoundSetter
    public void setVariables(@NonNull String variables) {
        this.variables = variables;
    }

    private static List<String> convertStringToList(@NonNull String variablesCommaSeparated) {
        String[] variablesArray = variablesCommaSeparated.split("\\s+");
        ArrayList<String> variables = new ArrayList<String>();
        for (String nameFragment : variablesArray) {
            if (nameFragment == null || nameFragment.isBlank()) continue;
            variables.add(nameFragment.toLowerCase(Locale.ENGLISH));
        }
        Collections.sort(variables);
        return variables;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String getVariables() {
        return this.variables;
    }

    @DataBoundSetter
    public void setRetainCharacteristicEnvVars(boolean retainCharacteristicEnvVars) {
        this.retainCharacteristicEnvVars = retainCharacteristicEnvVars;
    }

    public boolean isRetainCharacteristicEnvVars() {
        return this.retainCharacteristicEnvVars;
    }

    private List<String> variablesToRetain() {
        ArrayList<String> vars = new ArrayList<String>(RetainVariablesLocalRule.convertStringToList(this.variables));
        if (this.isRetainCharacteristicEnvVars()) {
            vars.addAll(CHARACTERISTIC_ENV_VARS);
        }
        return vars;
    }

    @Override
    public void filter(@NonNull EnvVars envVars, @NonNull EnvVarsFilterRuleContext context) {
        Map<String, String> systemEnvVars = EnvVars.masterEnvVars;
        ArrayList<String> variablesRemoved = new ArrayList<String>();
        ArrayList<String> variablesReset = new ArrayList<String>();
        List<String> variables = this.variablesToRetain();
        Iterator iterator = envVars.entrySet().iterator();
        block4: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String variableName2 = (String)entry.getKey();
            String variableValue = (String)entry.getValue();
            if (variables.contains(variableName2.toLowerCase(Locale.ENGLISH))) continue;
            String systemValue = systemEnvVars.get(variableName2);
            if (systemValue == null) {
                variablesRemoved.add(variableName2);
                iterator.remove();
                continue;
            }
            switch (this.processVariablesHandling.ordinal()) {
                case 0: {
                    if (systemValue.equals(variableValue)) continue block4;
                    variablesReset.add(variableName2);
                    continue block4;
                }
                case 1: {
                    variablesRemoved.add(variableName2);
                    iterator.remove();
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unknown process variables handling: " + String.valueOf((Object)this.processVariablesHandling)));
        }
        if (!variablesRemoved.isEmpty()) {
            context.getTaskListener().getLogger().println(Messages.RetainVariablesLocalRule_RemovalMessage(this.getDescriptor().getDisplayName(), String.join((CharSequence)", ", variablesRemoved)));
        }
        if (!variablesReset.isEmpty()) {
            variablesReset.forEach(variableName -> envVars.put((String)variableName, (String)systemEnvVars.get(variableName)));
            context.getTaskListener().getLogger().println(Messages.RetainVariablesLocalRule_ResetMessage(this.getDescriptor().getDisplayName(), String.join((CharSequence)", ", variablesReset)));
        }
    }

    public ProcessVariablesHandling getProcessVariablesHandling() {
        return this.processVariablesHandling;
    }

    @DataBoundSetter
    public void setProcessVariablesHandling(ProcessVariablesHandling processVariablesHandling) {
        this.processVariablesHandling = processVariablesHandling;
    }

    public static enum ProcessVariablesHandling {
        RESET(Messages._RetainVariablesLocalRule_RESET_DisplayName()),
        REMOVE(Messages._RetainVariablesLocalRule_REMOVE_DisplayName());

        private final Localizable localizable;

        private ProcessVariablesHandling(Localizable localizable) {
            this.localizable = localizable;
        }

        public String getDisplayName() {
            return this.localizable.toString();
        }
    }

    @Extension(ordinal=1000.0)
    @Symbol(value={"retainOnlyVariables"})
    public static final class DescriptorImpl
    extends EnvVarsFilterLocalRuleDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRetainCharacteristicEnvVars(@QueryParameter boolean value) {
            if (!value) {
                return FormValidation.warning(Messages.RetainVariablesLocalRule_CharacteristicEnvVarsFormValidationWarning());
            }
            return FormValidation.ok(Messages.RetainVariablesLocalRule_CharacteristicEnvVarsFormValidationOK());
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.RetainVariablesLocalRule_DisplayName();
        }

        @Override
        public boolean isApplicable(@NonNull Class<? extends EnvVarsFilterableBuilder> builderClass) {
            return true;
        }
    }
}

