/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.seed;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import jakarta.servlet.http.HttpSession;
import jenkins.security.SecurityListener;
import jenkins.security.seed.UserSeedProperty;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.userdetails.UserDetails;

@Restricted(value={NoExternalUse.class})
@Extension(ordinal=2.147483647E9)
public class UserSeedSecurityListener
extends SecurityListener {
    @Override
    protected void loggedIn(@NonNull String username) {
        UserSeedSecurityListener.putUserSeedInSession(username, true);
    }

    @Override
    protected void authenticated2(@NonNull UserDetails details) {
        UserSeedSecurityListener.putUserSeedInSession(details.getUsername(), false);
    }

    private static void putUserSeedInSession(String username, boolean overwriteSessionSeed) {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req == null) {
            return;
        }
        HttpSession session = req.getSession(false);
        if (session == null) {
            return;
        }
        if (!UserSeedProperty.DISABLE_USER_SEED) {
            if (!overwriteSessionSeed && session.getAttribute("_JENKINS_SESSION_SEED") != null) {
                return;
            }
            User user = User.getById(username, true);
            UserSeedProperty userSeed = user.getProperty(UserSeedProperty.class);
            if (userSeed == null) {
                return;
            }
            String sessionSeed = userSeed.getSeed();
            session.setAttribute("_JENKINS_SESSION_SEED", (Object)sessionSeed);
        }
    }
}

