/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;

public interface SecureRequester
extends ExtensionPoint {
    @StaplerNotDispatchable
    default public boolean permit(StaplerRequest2 req, Object bean) {
        return Util.ifOverridden(() -> this.permit(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), bean), SecureRequester.class, this.getClass(), "permit", StaplerRequest.class, Object.class);
    }

    @Deprecated
    @StaplerNotDispatchable
    default public boolean permit(StaplerRequest req, Object bean) {
        return Util.ifOverridden(() -> this.permit(StaplerRequest.toStaplerRequest2((StaplerRequest)req), bean), SecureRequester.class, this.getClass(), "permit", StaplerRequest2.class, Object.class);
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class Default
    implements SecureRequester {
        private static final String PROP = "hudson.model.Api.INSECURE";
        private static final boolean INSECURE = SystemProperties.getBoolean("hudson.model.Api.INSECURE");

        @Override
        public boolean permit(StaplerRequest2 req, Object bean) {
            return INSECURE || !Jenkins.get().isUseSecurity();
        }

        static {
            if (INSECURE) {
                Logger.getLogger(SecureRequester.class.getName()).warning("hudson.model.Api.INSECURE system property is deprecated; implement SecureRequester instead");
            }
        }
    }
}

