/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnosis;

import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.diagnosis.Messages;
import hudson.model.AdministrativeMonitor;
import hudson.util.jna.Kernel32Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.diagnosis.HsErrPidFile;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerDispatchable;
import jenkins.util.JavaVMArguments;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"hsErrPid"})
public class HsErrPidList
extends AdministrativeMonitor {
    final List<HsErrPidFile> files = new ArrayList<HsErrPidFile>();
    private MappedByteBuffer map;
    private static final String ERROR_FILE_OPTION = "-XX:ErrorFile=";
    private static final Logger LOGGER = Logger.getLogger(HsErrPidList.class.getName());

    public HsErrPidList() {
        if (Functions.getIsUnitTest()) {
            return;
        }
        try {
            try (FileChannel ch = FileChannel.open(this.getSecretKeyFile().toPath(), StandardOpenOption.READ);){
                this.map = ch.map(FileChannel.MapMode.READ_ONLY, 0L, 1L);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            this.scan("./hs_err_pid%p.log");
            if (Functions.isWindows()) {
                File dir = Kernel32Utils.getTempDir();
                if (dir != null) {
                    this.scan(dir.getPath() + "\\hs_err_pid%p.log");
                }
            } else {
                this.scan("/tmp/hs_err_pid%p.log");
            }
            for (String a : JavaVMArguments.current()) {
                if (!a.startsWith(ERROR_FILE_OPTION)) continue;
                this.scan(a.substring(ERROR_FILE_OPTION.length()));
            }
        }
        catch (UnsupportedOperationException dir) {
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to list up hs_err_pid files", e);
        }
    }

    @Override
    public String getDisplayName() {
        return Messages.HsErrPidList_DisplayName();
    }

    @StaplerDispatchable
    public List<HsErrPidFile> getFiles() {
        return this.files;
    }

    private void scan(String pattern) {
        LOGGER.fine("Scanning " + pattern + " for hs_err_pid files");
        pattern = pattern.replace("%p", "*").replace("%%", "%");
        File f = new File(pattern).getAbsoluteFile();
        if (!pattern.contains("*")) {
            this.scanFile(f);
        } else {
            File commonParent;
            for (commonParent = f; commonParent != null && commonParent.getPath().contains("*"); commonParent = commonParent.getParentFile()) {
            }
            if (commonParent == null) {
                LOGGER.warning("Failed to process " + String.valueOf(f));
                return;
            }
            FileSet fs = Util.createFileSet(commonParent, f.getPath().substring(commonParent.getPath().length() + 1), null);
            DirectoryScanner ds = fs.getDirectoryScanner(new Project());
            for (String child : ds.getIncludedFiles()) {
                this.scanFile(new File(commonParent, child));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanFile(File log) {
        LOGGER.fine("Scanning " + String.valueOf(log));
        try (BufferedReader rawReader = Files.newBufferedReader(log.toPath(), Charset.defaultCharset());
             BufferedReader r = new BufferedReader(rawReader);){
            String line;
            if (!this.findHeader(r)) {
                return;
            }
            String secretKey = this.getSecretKeyFile().getAbsolutePath();
            do {
                if ((line = r.readLine()) == null) return;
            } while (!line.contains(secretKey));
            this.files.add(new HsErrPidFile(this, log));
            return;
        }
        catch (IOException | InvalidPathException e) {
            LOGGER.log(Level.FINE, "Failed to parse hs_err_pid file: " + String.valueOf(log), e);
        }
    }

    private File getSecretKeyFile() {
        return new File(Jenkins.get().getRootDir(), "secret.key");
    }

    private boolean findHeader(BufferedReader r) throws IOException {
        for (int i = 0; i < 5; ++i) {
            String line = r.readLine();
            if (line == null) {
                return false;
            }
            if (!line.startsWith("# A fatal error has been detected by the Java Runtime Environment:")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActivated() {
        return !this.files.isEmpty();
    }
}

