/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.ChannelClosedException;
import hudson.tasks.Builder;
import hudson.tasks.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.filters.EnvVarsFilterException;
import jenkins.tasks.filters.EnvVarsFilterLocalRule;
import jenkins.tasks.filters.EnvVarsFilterableBuilder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class CommandInterpreter
extends Builder
implements EnvVarsFilterableBuilder {
    protected final String command;
    @Restricted(value={Beta.class})
    protected List<EnvVarsFilterLocalRule> configuredLocalRules = new ArrayList<EnvVarsFilterLocalRule>();
    private static final Logger LOGGER = Logger.getLogger(CommandInterpreter.class.getName());

    protected CommandInterpreter(String command) {
        this.command = command;
    }

    public final String getCommand() {
        return this.command;
    }

    @Override
    @NonNull
    public List<EnvVarsFilterLocalRule> buildEnvVarsFilterRules() {
        return this.configuredLocalRules == null ? Collections.emptyList() : new ArrayList<EnvVarsFilterLocalRule>(this.configuredLocalRules);
    }

    @Restricted(value={NoExternalUse.class})
    public List<EnvVarsFilterLocalRule> getConfiguredLocalRules() {
        return this.configuredLocalRules == null ? Collections.emptyList() : this.configuredLocalRules;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        return this.perform(build, launcher, (TaskListener)listener);
    }

    protected boolean isErrorlevelForUnstableBuild(int exitCode) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws InterruptedException {
        FilePath ws = build.getWorkspace();
        if (ws == null) {
            Node node = build.getBuiltOn();
            if (node == null) {
                throw new NullPointerException("no such build node: " + build.getBuiltOnStr());
            }
            throw new NullPointerException("no workspace from node " + String.valueOf(node) + " which is computer " + String.valueOf(node.toComputer()) + " and has channel " + String.valueOf(node.getChannel()));
        }
        FilePath script = null;
        int r = -1;
        try {
            script = this.createScriptFile(ws);
        }
        catch (IOException e) {
            Util.displayIOException(e, listener);
            Functions.printStackTrace((Throwable)e, listener.fatalError(Messages.CommandInterpreter_UnableToProduceScript()));
            boolean bl = false;
            try {
                if (script != null) {
                    script.delete();
                }
            }
            catch (IOException e2) {
                if (r == -1 && e2.getCause() instanceof ChannelClosedException) {
                    LOGGER.log(Level.FINE, "Script deletion failed", e2);
                } else {
                    Util.displayIOException(e2, listener);
                    Functions.printStackTrace((Throwable)e2, listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
                }
            }
            catch (Exception e3) {
                Functions.printStackTrace((Throwable)e3, listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
            }
            return bl;
        }
        EnvVars envVars = build.getEnvironment(listener);
        for (Map.Entry<String, String> e : build.getBuildVariables().entrySet()) {
            envVars.put(e.getKey(), e.getValue());
        }
        launcher.prepareFilterRules(build, this);
        Launcher.ProcStarter procStarter = launcher.launch();
        procStarter.cmds(this.buildCommandLine(script)).envs(envVars).stdout(listener).pwd(ws);
        try {
            Proc proc = procStarter.start();
            r = this.join(proc);
        }
        catch (EnvVarsFilterException se) {
            LOGGER.log(Level.FINE, "Environment variable filtering failed", se);
            boolean bl = false;
            try {
                if (script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                if (r == -1 && e.getCause() instanceof ChannelClosedException) {
                    LOGGER.log(Level.FINE, "Script deletion failed", e);
                } else {
                    Util.displayIOException(e, listener);
                    Functions.printStackTrace((Throwable)e, listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
                }
            }
            catch (Exception e) {
                Functions.printStackTrace((Throwable)e, listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
            }
            return bl;
        }
        try {
            try {
                if (this.isErrorlevelForUnstableBuild(r)) {
                    build.setResult(Result.UNSTABLE);
                    r = 0;
                }
            }
            catch (IOException e) {
                Util.displayIOException(e, listener);
                Functions.printStackTrace((Throwable)e, listener.fatalError(Messages.CommandInterpreter_CommandFailed()));
            }
            boolean bl = r == 0;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                if (r == -1 && e.getCause() instanceof ChannelClosedException) {
                    LOGGER.log(Level.FINE, "Script deletion failed", e);
                } else {
                    Util.displayIOException(e, listener);
                    Functions.printStackTrace((Throwable)e, listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
                }
            }
            catch (Exception e) {
                Functions.printStackTrace((Throwable)e, listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
            }
        }
    }

    protected int join(Proc p) throws IOException, InterruptedException {
        return p.join();
    }

    public FilePath createScriptFile(@NonNull FilePath dir) throws IOException, InterruptedException {
        return dir.createTextTempFile("jenkins", this.getFileExtension(), this.getContents(), false);
    }

    public abstract String[] buildCommandLine(FilePath var1);

    protected abstract String getContents();

    protected abstract String getFileExtension();
}

