/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Queue;
import hudson.scheduler.CronTabList;
import hudson.slaves.Messages;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SimpleScheduledRetentionStrategy
extends RetentionStrategy<SlaveComputer> {
    private static final Logger LOGGER = Logger.getLogger(SimpleScheduledRetentionStrategy.class.getName());
    private final String startTimeSpec;
    private transient CronTabList tabs;
    private transient Calendar lastChecked;
    private transient long nextStop = Long.MIN_VALUE;
    private transient long nextStart = Long.MIN_VALUE;
    private transient long lastStop = Long.MAX_VALUE;
    private transient long lastStart = Long.MAX_VALUE;
    private final int upTimeMins;
    private final boolean keepUpWhenActive;

    @DataBoundConstructor
    public SimpleScheduledRetentionStrategy(String startTimeSpec, int upTimeMins, boolean keepUpWhenActive) {
        this.startTimeSpec = startTimeSpec;
        this.keepUpWhenActive = keepUpWhenActive;
        this.tabs = CronTabList.create(startTimeSpec);
        this.lastChecked = new GregorianCalendar();
        this.upTimeMins = Math.max(1, upTimeMins);
        this.lastChecked.add(12, -1);
    }

    public int getUpTimeMins() {
        return this.upTimeMins;
    }

    public boolean isKeepUpWhenActive() {
        return this.keepUpWhenActive;
    }

    public String getStartTimeSpec() {
        return this.startTimeSpec;
    }

    private synchronized void updateStartStopWindow() {
        GregorianCalendar time;
        if (this.lastStart == Long.MAX_VALUE && this.lastStop == Long.MAX_VALUE) {
            time = new GregorianCalendar();
            ((Calendar)time).add(12, -this.upTimeMins);
            ((Calendar)time).add(12, -this.upTimeMins);
            ((Calendar)time).add(12, -this.upTimeMins);
            this.lastStart = time.getTimeInMillis();
            ((Calendar)time).add(12, this.upTimeMins);
            this.lastStop = time.getTimeInMillis();
            time = new GregorianCalendar();
            ((Calendar)time).add(12, -this.upTimeMins);
            ((Calendar)time).add(12, -1);
            while (System.currentTimeMillis() + 1000L > time.getTimeInMillis()) {
                if (this.tabs.check(time)) {
                    this.lastStart = time.getTimeInMillis();
                    ((Calendar)time).add(12, this.upTimeMins);
                    this.lastStop = time.getTimeInMillis();
                    break;
                }
                ((Calendar)time).add(12, 1);
            }
            this.nextStart = this.lastStart;
            this.nextStop = this.lastStop;
        }
        if (this.nextStop < System.currentTimeMillis()) {
            this.lastStart = this.nextStart;
            this.lastStop = this.nextStop;
            time = new GregorianCalendar();
            ((Calendar)time).add(12, Math.min(15, this.upTimeMins));
            long stopLooking = time.getTimeInMillis();
            time.setTimeInMillis(this.nextStop);
            while (stopLooking > time.getTimeInMillis()) {
                if (this.tabs.check(time)) {
                    this.nextStart = time.getTimeInMillis();
                    ((Calendar)time).add(12, this.upTimeMins);
                    this.nextStop = time.getTimeInMillis();
                    break;
                }
                ((Calendar)time).add(12, 1);
            }
        }
    }

    protected synchronized Object readResolve() throws ObjectStreamException {
        try {
            this.tabs = CronTabList.create(this.startTimeSpec);
            this.lastChecked = new GregorianCalendar();
            this.lastChecked.add(12, -1);
            this.nextStop = Long.MIN_VALUE;
            this.nextStart = Long.MIN_VALUE;
            this.lastStop = Long.MAX_VALUE;
            this.lastStart = Long.MAX_VALUE;
        }
        catch (IllegalArgumentException e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
        return this;
    }

    @Override
    public boolean isManualLaunchAllowed(SlaveComputer c) {
        return this.isOnlineScheduled();
    }

    @Override
    public boolean isAcceptingTasks(SlaveComputer c) {
        return this.isOnlineScheduled();
    }

    @Override
    @GuardedBy(value="hudson.model.Queue.lock")
    public synchronized long check(final SlaveComputer c) {
        boolean shouldBeOnline = this.isOnlineScheduled();
        LOGGER.log(Level.FINE, "Checking computer {0} against schedule. online = {1}, shouldBeOnline = {2}", new Object[]{c.getName(), c.isOnline(), shouldBeOnline});
        if (shouldBeOnline && c.isOffline()) {
            LOGGER.log(Level.INFO, "Trying to launch computer {0} as schedule says it should be on-line at this point in time", new Object[]{c.getName()});
            if (c.isLaunchSupported()) {
                Computer.threadPoolForRemoting.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            c.connect(true).get();
                            if (c.isOnline()) {
                                LOGGER.log(Level.INFO, "Launched computer {0} per schedule", new Object[]{c.getName()});
                            }
                            if (SimpleScheduledRetentionStrategy.this.keepUpWhenActive && c.isOnline() && !c.isAcceptingTasks()) {
                                LOGGER.log(Level.INFO, "Enabling new jobs for computer {0} as it has started its scheduled uptime", new Object[]{c.getName()});
                            }
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            // empty catch block
                        }
                    }
                });
            }
        } else if (!shouldBeOnline && c.isOnline()) {
            if (c.isLaunchSupported()) {
                if (this.keepUpWhenActive) {
                    if (!c.isIdle() && c.isAcceptingTasks()) {
                        LOGGER.log(Level.INFO, "Disabling new jobs for computer {0} as it has finished its scheduled uptime", new Object[]{c.getName()});
                        return 0L;
                    }
                    if (c.isIdle() && c.isAcceptingTasks()) {
                        Queue.runWithLock(() -> {
                            if (c.isIdle()) {
                                LOGGER.log(Level.INFO, "Disconnecting computer {0} as it has finished its scheduled uptime", new Object[]{c.getName()});
                                c.disconnect(OfflineCause.create(Messages._SimpleScheduledRetentionStrategy_FinishedUpTime()));
                            }
                        });
                    } else if (c.isIdle() && !c.isAcceptingTasks()) {
                        Queue.runWithLock(() -> {
                            if (c.isIdle()) {
                                LOGGER.log(Level.INFO, "Disconnecting computer {0} as it has finished all jobs running when it completed its scheduled uptime", new Object[]{c.getName()});
                                c.disconnect(OfflineCause.create(Messages._SimpleScheduledRetentionStrategy_FinishedUpTime()));
                            }
                        });
                    }
                } else {
                    LOGGER.log(Level.INFO, "Disconnecting computer {0} as it has finished its scheduled uptime", new Object[]{c.getName()});
                    c.disconnect(OfflineCause.create(Messages._SimpleScheduledRetentionStrategy_FinishedUpTime()));
                }
            }
        } else {
            c.setOfflineCause(new ScheduledOfflineCause());
        }
        return 0L;
    }

    private synchronized boolean isOnlineScheduled() {
        this.updateStartStopWindow();
        long now = System.currentTimeMillis();
        return this.lastStart < now && this.lastStop > now || this.nextStart < now && this.nextStop > now;
    }

    public static class ScheduledOfflineCause
    extends OfflineCause.SimpleOfflineCause {
        public ScheduledOfflineCause() {
            super(Messages._SimpleScheduledRetentionStrategy_ScheduledOfflineCause_displayName());
        }

        @Override
        @NonNull
        public String getComputerIcon() {
            return "symbol-computer-not-accepting";
        }

        @Override
        @NonNull
        public String getIcon() {
            return "symbol-trigger";
        }
    }

    @Extension
    @Symbol(value={"schedule"})
    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SimpleScheduledRetentionStrategy_displayName();
        }

        public FormValidation doCheck(@QueryParameter String value) {
            try {
                String msg = CronTabList.create(Util.fixNull(value)).checkSanity();
                if (msg != null) {
                    return FormValidation.warning(msg);
                }
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error(e, e.getMessage());
            }
        }
    }
}

