/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.SidACL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.acls.sid.Sid;
import org.springframework.security.core.Authentication;

public class SparseACL
extends SidACL {
    private final List<Entry> entries = new ArrayList<Entry>();
    private ACL parent;
    private static final Logger LOGGER = Logger.getLogger(SparseACL.class.getName());

    public SparseACL(ACL parent) {
        this.parent = parent;
    }

    public void add(Entry e) {
        this.entries.add(e);
    }

    public void add(Sid sid, Permission permission, boolean allowed) {
        this.add(new Entry(sid, permission, allowed));
    }

    @Override
    public boolean hasPermission2(Authentication a, Permission permission) {
        if (a.equals((Object)SYSTEM2)) {
            return true;
        }
        Boolean b = this._hasPermission(a, permission);
        if (b != null) {
            return b;
        }
        if (this.parent != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("hasPermission(" + String.valueOf(a) + "," + String.valueOf(permission) + ") is delegating to parent ACL: " + String.valueOf(this.parent));
            }
            return this.parent.hasPermission2(a, permission);
        }
        return false;
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="converting this to YesNoMaybe would break backward compatibility")
    protected Boolean hasPermission(Sid p, Permission permission) {
        while (permission != null) {
            for (Entry e : this.entries) {
                if (e.permission != permission || !e.sid.equals(p)) continue;
                return e.allowed;
            }
            permission = permission.impliedBy;
        }
        return null;
    }

    public static final class Entry {
        public final Sid sid;
        public final Permission permission;
        public final boolean allowed;

        public Entry(Sid sid, Permission permission, boolean allowed) {
            this.sid = sid;
            this.permission = permission;
            this.allowed = allowed;
        }
    }
}

