/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.security.SecurityRealm;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@Restricted(value={NoExternalUse.class})
public final class ContainerAuthentication
implements Authentication {
    private final Principal principal;
    private Collection<? extends GrantedAuthority> authorities;

    public ContainerAuthentication(HttpServletRequest request) {
        this.principal = request.getUserPrincipal();
        if (this.principal == null) {
            throw new IllegalStateException();
        }
        ArrayList<? extends GrantedAuthority> l = new ArrayList<GrantedAuthority>();
        for (String g : Jenkins.get().getAuthorizationStrategy().getGroups()) {
            if (!request.isUserInRole(g)) continue;
            l.add((GrantedAuthority)new SimpleGrantedAuthority(g));
        }
        l.add(SecurityRealm.AUTHENTICATED_AUTHORITY2);
        this.authorities = l;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return null;
    }

    public Object getDetails() {
        return null;
    }

    public String getPrincipal() {
        return this.principal.getName();
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    public String getName() {
        return this.getPrincipal();
    }
}

