/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.Loadable;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class Plugin
implements Loadable,
Saveable,
StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(Plugin.class.getName());
    transient PluginWrapper wrapper;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(Plugin.class.getName() + ".skipPermissionCheck");

    @Deprecated
    protected Plugin() {
    }

    public void setServletContext(ServletContext context) {
    }

    public PluginWrapper getWrapper() {
        return this.wrapper;
    }

    public void start() throws Exception {
    }

    public void postInitialize() throws Exception {
    }

    public void stop() throws Exception {
    }

    @Deprecated
    public void configure(JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
    }

    public void configure(StaplerRequest2 req, JSONObject formData) throws IOException, jakarta.servlet.ServletException, Descriptor.FormException {
        try {
            if (Util.isOverridden(Plugin.class, this.getClass(), "configure", StaplerRequest.class, JSONObject.class)) {
                this.configure(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), formData);
            } else {
                this.configure(formData);
            }
        }
        catch (ServletException e) {
            throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
        }
    }

    @Deprecated
    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.configure(formData);
    }

    public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        if (Util.isOverridden(Plugin.class, this.getClass(), "doDynamic", StaplerRequest.class, StaplerResponse.class)) {
            try {
                this.doDynamic(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
            }
        } else {
            this.doDynamicImpl(req, rsp);
        }
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        try {
            this.doDynamicImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    private void doDynamicImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        String path = req.getRestOfPath();
        String pathUC = path.toUpperCase(Locale.ENGLISH);
        if (path.isEmpty() || path.contains("..") || path.startsWith(".") || path.contains("%") || pathUC.contains("META-INF") || pathUC.contains("WEB-INF") || pathUC.equals("/.TIMESTAMP2")) {
            LOGGER.warning("rejecting possibly malicious " + req.getRequestURIWithQueryString());
            rsp.sendError(400);
            return;
        }
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        boolean staticLink = requestPath.startsWith("/static/");
        long expires = staticLink ? TimeUnit.DAYS.toMillis(365L) : -1L;
        rsp.serveLocalizedFile(req, new URL(this.wrapper.baseResourceURL, "." + path), expires);
    }

    @Override
    public synchronized void load() throws IOException {
        XmlFile xml = this.getConfigXml();
        if (xml.exists()) {
            xml.unmarshal(this);
        }
    }

    @Override
    public synchronized void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        XmlFile config = this.getConfigXml();
        config.write(this);
        SaveableListener.fireOnChange(this, config);
    }

    protected XmlFile getConfigXml() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.get().getRootDir(), this.wrapper.getShortName() + ".xml"));
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK) {
            Jenkins.get().checkPermission(Jenkins.READ);
        }
        return this;
    }

    public static final class DummyImpl
    extends Plugin {
    }
}

