/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionComponent;
import hudson.ExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ExtensionComponentSet;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.Stapler;

public class DescriptorExtensionList<T extends Describable<T>, D extends Descriptor<T>>
extends ExtensionList<D> {
    private final Class<T> describableType;
    private static final Logger LOGGER = Logger.getLogger(DescriptorExtensionList.class.getName());

    public static <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> createDescriptorList(Jenkins jenkins, Class<T> describableType) {
        if (describableType == Publisher.class) {
            return new Publisher.DescriptorExtensionListImpl(jenkins);
        }
        return new DescriptorExtensionList<T, D>(jenkins, describableType);
    }

    @Deprecated
    public static <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> createDescriptorList(Hudson hudson, Class<T> describableType) {
        return DescriptorExtensionList.createDescriptorList((Jenkins)hudson, describableType);
    }

    @Deprecated
    protected DescriptorExtensionList(Hudson hudson, Class<T> describableType) {
        this((Jenkins)hudson, describableType);
    }

    protected DescriptorExtensionList(Jenkins jenkins, Class<T> describableType) {
        super(jenkins, Descriptor.class);
        this.describableType = describableType;
    }

    @Deprecated
    public D find(String fqcn) {
        return (D)Descriptor.find(this, fqcn);
    }

    public D find(Class<? extends T> type) {
        for (Descriptor d : this) {
            if (d.clazz != type) continue;
            return (D)d;
        }
        return null;
    }

    @CheckForNull
    public T newInstanceFromRadioList(JSONObject config) throws Descriptor.FormException {
        if (config.isNullObject()) {
            return null;
        }
        int idx = config.getInt("value");
        return ((Descriptor)this.get(idx)).newInstance(Stapler.getCurrentRequest2(), config);
    }

    @CheckForNull
    public T newInstanceFromRadioList(@NonNull JSONObject parent, @NonNull String name) throws Descriptor.FormException {
        try {
            return this.newInstanceFromRadioList(parent.getJSONObject(name));
        }
        catch (JSONException ex) {
            throw new Descriptor.FormException(ex, name);
        }
    }

    @CheckForNull
    public D findByName(String id) {
        for (Descriptor d : this) {
            if (!d.getId().equals(id)) continue;
            return (D)d;
        }
        return null;
    }

    @Override
    public boolean add(D d) {
        boolean r = super.add(d);
        this.getDescriptorExtensionList().add((Descriptor)d);
        return r;
    }

    @Override
    public boolean remove(Object o) {
        this.getDescriptorExtensionList().remove(o);
        return super.remove(o);
    }

    @Override
    protected Object getLoadLock() {
        return this.getDescriptorExtensionList().getLoadLock();
    }

    @Override
    protected List<ExtensionComponent<D>> load() {
        if (this.jenkins == null) {
            LOGGER.log(Level.WARNING, "Cannot load extension components, because Jenkins instance has not been assigned yet");
            return Collections.emptyList();
        }
        return this._load(this.getDescriptorExtensionList().getComponents());
    }

    @Override
    protected Collection<ExtensionComponent<D>> load(ExtensionComponentSet delta) {
        return this._load(delta.find(Descriptor.class));
    }

    private List<ExtensionComponent<D>> _load(Iterable<ExtensionComponent<Descriptor>> set) {
        ArrayList<ExtensionComponent<D>> r = new ArrayList<ExtensionComponent<D>>();
        for (ExtensionComponent<Descriptor> c : set) {
            Descriptor d = c.getInstance();
            try {
                if (d.getT() != this.describableType) continue;
                r.add(c);
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.SEVERE, String.valueOf(d.getClass()) + " doesn't extend Descriptor with a type parameter", e);
            }
        }
        return r;
    }

    private ExtensionList<Descriptor> getDescriptorExtensionList() {
        return ExtensionList.lookup(Descriptor.class);
    }

    @Deprecated
    public static Iterable<Descriptor> listLegacyInstances() {
        return List.of();
    }

    @Deprecated
    @SuppressFBWarnings(value={"HSM_HIDING_METHOD"}, justification="irrelevant now")
    public static void clearLegacyInstances() {
    }
}

