/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.IntMorpher;

public final class IntArrayMorpher
extends AbstractArrayMorpher {
    private static final Class INT_ARRAY_CLASS = int[].class;
    private int defaultValue;

    public IntArrayMorpher() {
        super(false);
    }

    public IntArrayMorpher(int defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntArrayMorpher)) {
            return false;
        }
        IntArrayMorpher other = (IntArrayMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (INT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (int[])array;
        }
        if (array.getClass().isArray()) {
            IntMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Integer.TYPE, dimensions);
            IntMorpher intMorpher = morpher = this.isUseDefault() ? new IntMorpher(this.defaultValue) : new IntMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.setInt(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + String.valueOf(array.getClass()));
    }

    @Override
    public Class morphsTo() {
        return INT_ARRAY_CLASS;
    }
}

