/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.hudson.AbstractMemoryMonitorImpl;
import org.jvnet.hudson.MemoryUsage;

public class Solaris
extends AbstractMemoryMonitorImpl {
    private static final Pattern NUMBER_ONLY = Pattern.compile("[0-9 ]+");
    private static final Pattern USED_SWAP = Pattern.compile(" ([0-9]+)k used");
    private static final Pattern AVAILABLE_SWAP = Pattern.compile(" ([0-9]+)k available");

    @Override
    public MemoryUsage monitor() throws IOException {
        long[] v = this.getSwap();
        return new MemoryUsage(this.getTotalPhysicalMemory(), this.getAvailablePhysicalMemory(), v[0], v[1]);
    }

    private long getTotalPhysicalMemory() throws IOException {
        Process proc = this.startProcess("/usr/sbin/prtdiag");
        try (BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));){
            String line;
            while ((line = r.readLine()) != null) {
                if (!line.contains("Memory size:")) continue;
                line = line.substring(line.indexOf(58) + 1).trim();
                long l = this.parse(line);
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    private long getAvailablePhysicalMemory() throws IOException {
        Process proc = this.startProcess("vmstat");
        try (BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));){
            String line;
            while ((line = r.readLine()) != null) {
                if (!NUMBER_ONLY.matcher(line).matches()) continue;
                long l = Long.parseLong(line.trim().split(" +")[4]) * 1024L;
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    private long[] getSwap() throws IOException {
        long[] v = new long[]{-1L, -1L};
        Process proc = this.startProcess("/usr/sbin/swap", "-s");
        try (BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));){
            String line = r.readLine();
            if (line == null) {
                throw new IOException("no output from /usr/sbin/swap -s");
            }
            Matcher m = USED_SWAP.matcher(line = line.toLowerCase());
            if (m.find()) {
                v[0] = Long.parseLong(m.group(1)) * 1024L;
            }
            if ((m = AVAILABLE_SWAP.matcher(line)).find()) {
                v[1] = Long.parseLong(m.group(1)) * 1024L;
            }
            if (v[0] != -1L && v[1] != -1L) {
                v[0] = v[0] + v[1];
            }
            long[] lArray = v;
            return lArray;
        }
    }

    private Process startProcess(String ... cmd) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        proc.getOutputStream().close();
        return proc;
    }
}

