/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import org.apache.commons.jelly.LocationAware;

public class JellyException
extends Exception
implements LocationAware {
    private String fileName;
    private String elementName;
    private int lineNumber = -1;
    private int columnNumber = -1;

    public JellyException() {
    }

    public JellyException(String message) {
        super(message);
    }

    public JellyException(String message, Throwable cause) {
        super(message, cause);
    }

    public JellyException(Throwable cause) {
        super(cause);
    }

    public JellyException(Throwable cause, String fileName, String elementName, int columnNumber, int lineNumber) {
        this(cause.getLocalizedMessage(), cause, fileName, elementName, columnNumber, lineNumber);
    }

    public JellyException(String reason, Throwable cause, String fileName, String elementName, int columnNumber, int lineNumber) {
        super(reason == null ? cause.getClass().getName() : reason, cause);
        this.fileName = fileName;
        this.elementName = elementName;
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
    }

    public JellyException(String reason, String fileName, String elementName, int columnNumber, int lineNumber) {
        super(reason);
        this.fileName = fileName;
        this.elementName = elementName;
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    @Override
    public String getMessage() {
        if (this.fileName == null && this.lineNumber == -1 && this.columnNumber == -1 && this.elementName == null) {
            return this.getReason();
        }
        return this.fileName + ":" + this.lineNumber + ":" + this.columnNumber + ": <" + this.elementName + "> " + this.getReason();
    }

    public String getReason() {
        return super.getMessage();
    }
}

