/*
 * Decompiled with CFR 0.152.
 */
package winstone.tools;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import java.util.logging.Level;
import winstone.Logger;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.CmdLineParser;
import winstone.cmdline.Option;

public class WinstoneControl {
    private static final WinstoneResourceBundle TOOLS_RESOURCES = new WinstoneResourceBundle("winstone.tools.LocalStrings");
    static final String OPERATION_SHUTDOWN = "shutdown";
    static final String OPERATION_RELOAD = "reload:";
    static int TIMEOUT = 10000;
    public static final Option.OInt CONTROL_PORT = Option.integer("controlPort");
    public static final Option.OInt PORT = Option.integer("port");
    public static final Option.OInt DEBUG = new Option.ODebugInt("debug", 5);
    public static final Option.OString HOST = Option.string("host", "localhost");

    public static void main(String[] argv) throws Exception {
        Map<String, String> options = new CmdLineParser(Option.all(WinstoneControl.class)).parse(argv, "operation");
        String operation = options.get("operation");
        if (operation.equals("")) {
            WinstoneControl.printUsage();
            return;
        }
        Logger.setCurrentDebugLevel(DEBUG.get(options));
        String host = HOST.get(options);
        int port = PORT.get(options, CONTROL_PORT.get(options));
        Logger.log(Level.INFO, TOOLS_RESOURCES, "WinstoneControl.UsingHostPort", host, port);
        if (operation.equalsIgnoreCase(OPERATION_SHUTDOWN)) {
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(TIMEOUT);
            try (OutputStream out = socket.getOutputStream();){
                out.write(48);
                Logger.log(Level.INFO, TOOLS_RESOURCES, "WinstoneControl.ShutdownOK", host, port);
            }
        }
        if (operation.toLowerCase().startsWith(OPERATION_RELOAD.toLowerCase())) {
            String webappName = operation.substring(OPERATION_RELOAD.length());
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(TIMEOUT);
            try (OutputStream out = socket.getOutputStream();
                 ObjectOutputStream objOut = new ObjectOutputStream(out);){
                out.write(52);
                objOut.writeUTF(host);
                objOut.writeUTF(webappName);
            }
            Logger.log(Level.INFO, TOOLS_RESOURCES, "WinstoneControl.ReloadOK", host, port);
        } else {
            WinstoneControl.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println(TOOLS_RESOURCES.getString("WinstoneControl.Usage"));
    }
}

