/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.jmx.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMBean
implements DynamicMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectMBean.class);
    protected final Object _managed;
    private MetaData _metaData;
    private MBeanContainer _mbeanContainer;

    public ObjectMBean(Object managedObject) {
        this._managed = managedObject;
    }

    public Object getManagedObject() {
        return this._managed;
    }

    public ObjectName getObjectName() {
        return null;
    }

    public String getObjectContextBasis() {
        return null;
    }

    public String getObjectNameBasis() {
        return null;
    }

    protected void setMBeanContainer(MBeanContainer container) {
        this._mbeanContainer = container;
    }

    public MBeanContainer getMBeanContainer() {
        return this._mbeanContainer;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.metaData().getMBeanInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, ReflectionException, MBeanException {
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object object = this.metaData().getAttribute(name, this);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList results = new AttributeList(names.length);
        for (String name : names) {
            try {
                results.add(new Attribute(name, this.getAttribute(name)));
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.atDebug().setCause(x).log("Unable to get attribute {}", (Object)name);
            }
        }
        return results;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, ReflectionException, MBeanException {
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.metaData().setAttribute(attribute, this);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList results = new AttributeList(attributes.size());
        for (Attribute attribute : attributes.asList()) {
            try {
                this.setAttribute(attribute);
                results.add(new Attribute(attribute.getName(), this.getAttribute(attribute.getName())));
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.atDebug().setCause(x).log("Unable to get Attribute {}", (Object)attribute);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String name, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object object = this.metaData().invoke(name, signature, params, this);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    ObjectName findObjectName(Object bean) {
        return this._mbeanContainer.findMBean(bean);
    }

    Object findBean(ObjectName objectName) {
        return this._mbeanContainer.findBean(objectName);
    }

    MetaData metaData() {
        if (this._metaData == null) {
            this._metaData = MBeanContainer.findMetaData(this._mbeanContainer, this._managed.getClass());
        }
        return this._metaData;
    }
}

