/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.time.LocalDate;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import jenkins.telemetry.Telemetry;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.EvaluationTrace;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Restricted(value={NoExternalUse.class})
public class StaplerDispatches
extends Telemetry {
    private static final Set<String> traces = new ConcurrentSkipListSet<String>();

    @Override
    @NonNull
    public LocalDate getStart() {
        return LocalDate.of(2018, 10, 10);
    }

    @Override
    @NonNull
    public LocalDate getEnd() {
        return LocalDate.of(2019, 8, 1);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Stapler request handling";
    }

    @Override
    public JSONObject createContent() {
        if (traces.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> info = new TreeMap<String, Object>();
        info.put("components", this.buildComponentInformation());
        info.put("dispatches", this.buildDispatches());
        return JSONObject.fromObject(info);
    }

    private Object buildDispatches() {
        TreeSet<String> currentTraces = new TreeSet<String>(traces);
        traces.clear();
        return currentTraces;
    }

    public static class StaplerTrace
    extends EvaluationTrace.ApplicationTracer {
        protected void record(StaplerRequest2 staplerRequest, String s) {
            if (Telemetry.isDisabled()) {
                return;
            }
            traces.add(s);
        }
    }
}

