/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.security.csp.Contributor;
import jenkins.security.csp.Directive;
import jenkins.security.csp.FetchDirective;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={Beta.class})
public class CspBuilder {
    private static final Logger LOGGER = Logger.getLogger(CspBuilder.class.getName());
    private static final List<String> NONE_DIRECTIVES = List.of("base-uri", "frame-ancestors", "form-action");
    private final Map<String, Set<String>> directives = new HashMap<String, Set<String>>();
    private final EnumSet<FetchDirective> initializedFDs = EnumSet.noneOf(FetchDirective.class);
    @Restricted(value={NoExternalUse.class})
    static final Set<String> PROHIBITED_KEYS = Set.of("report-uri", "report-to");

    public CspBuilder withDefaultContributions() {
        Contributor.all().forEach(c -> {
            try {
                c.apply(this);
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "Failed to apply CSP contributions from " + String.valueOf(c), ex);
            }
        });
        return this;
    }

    public CspBuilder add(String directive, String ... values) {
        if (PROHIBITED_KEYS.contains(directive)) {
            LOGGER.config("Directive " + directive + " cannot be set manually");
            return this;
        }
        this.directives.compute(directive, (k, current) -> {
            Set nonNullAdditions;
            ArrayList<String> additions = new ArrayList<String>(Arrays.stream(values).toList());
            if (additions.contains("'none'")) {
                LOGGER.config("Cannot explicitly add 'none'. See " + Directive.class.getName() + "#NONE Javadoc.");
                additions.remove("'none'");
            }
            if ((nonNullAdditions = additions.stream().filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty() != additions.isEmpty()) {
                return current;
            }
            if (current == null) {
                return new HashSet(nonNullAdditions);
            }
            nonNullAdditions.addAll(current);
            return nonNullAdditions;
        });
        return this;
    }

    public CspBuilder remove(String directive, String ... values) {
        if (values.length == 0) {
            if (FetchDirective.isFetchDirective(directive)) {
                this.initializedFDs.remove((Object)FetchDirective.fromKey(directive));
            }
            this.directives.remove(directive);
        } else {
            this.directives.compute(directive, (k, v) -> {
                if (v == null) {
                    return null;
                }
                Arrays.asList(values).forEach(v::remove);
                return v;
            });
        }
        return this;
    }

    public CspBuilder initialize(FetchDirective fetchDirective, String ... values) {
        this.add(fetchDirective.toKey(), values);
        if (this.directives.containsKey(fetchDirective.toKey())) {
            this.initializedFDs.add(fetchDirective);
        } else {
            LOGGER.log(Level.CONFIG, "Ignoring initialization call with no-op null values list for " + fetchDirective.toKey());
        }
        return this;
    }

    public List<Directive> getMergedDirectives() {
        ArrayList<Directive> result = new ArrayList<Directive>();
        for (Map.Entry<String, Set<String>> entry : this.directives.entrySet()) {
            HashSet effectiveValues = new HashSet();
            String name = entry.getKey();
            if (FetchDirective.isFetchDirective(name)) {
                FetchDirective current = FetchDirective.fromKey(name);
                boolean wasInitialized = this.initializedFDs.contains((Object)current);
                if (!wasInitialized) {
                    FetchDirective fallback;
                    for (fallback = current.getFallback(); fallback != null && !this.initializedFDs.contains((Object)fallback); fallback = fallback.getFallback()) {
                    }
                    if (fallback == null) {
                        fallback = FetchDirective.DEFAULT_SRC;
                    }
                    if (this.directives.containsKey(fallback.toKey())) {
                        effectiveValues.addAll(this.directives.get(fallback.toKey()));
                    }
                }
                effectiveValues.addAll(entry.getValue());
                result.add(new Directive(name, !wasInitialized, List.copyOf(effectiveValues)));
                continue;
            }
            effectiveValues.addAll(entry.getValue());
            result.add(new Directive(name, null, List.copyOf(effectiveValues)));
        }
        return List.copyOf(result);
    }

    public String build() {
        return this.buildDirectives().entrySet().stream().map(e -> {
            if (((String)e.getValue()).isEmpty()) {
                return (String)e.getKey() + ";";
            }
            return (String)e.getKey() + " " + (String)e.getValue() + ";";
        }).collect(Collectors.joining(" "));
    }

    public Map<String, String> buildDirectives() {
        return this.getMergedDirectives().stream().sorted(Comparator.comparing(Directive::name)).map(directive -> {
            String name = directive.name();
            List<Object> values = directive.values().stream().sorted(String::compareTo).toList();
            if (values.isEmpty() && (FetchDirective.isFetchDirective(name) || NONE_DIRECTIVES.contains(name))) {
                values = List.of("'none'");
            }
            return Map.entry(name, String.join((CharSequence)" ", values));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, TreeMap::new));
    }
}

