/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.SubTask;
import hudson.model.queue.WorkUnitContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class WorkUnit {
    public final SubTask work;
    public final WorkUnitContext context;
    private volatile Executor executor;
    private Queue.Executable executable;

    WorkUnit(WorkUnitContext context, SubTask work) {
        this.context = context;
        this.work = work;
    }

    @CheckForNull
    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(@CheckForNull Executor e) {
        this.executor = e;
        if (e != null) {
            this.context.future.addExecutor(e);
        }
    }

    @CheckForNull
    public Queue.Executable getExecutable() {
        return this.executable;
    }

    @Restricted(value={NoExternalUse.class})
    public void setExecutable(Queue.Executable executable) {
        this.executable = executable;
        if (executable instanceof Run) {
            ((Run)((Object)executable)).setQueueId(this.context.item.getId());
        }
    }

    public boolean isMainWork() {
        return this.context.task == this.work;
    }

    public String toString() {
        if (this.work == this.context.task) {
            return super.toString() + "[work=" + this.context.task.getFullDisplayName() + "]";
        }
        return super.toString() + "[work=" + String.valueOf(this.work) + ",context.task=" + this.context.task.getFullDisplayName() + "]";
    }
}

