/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.lang;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.kohsuke.stapler.lang.AnnotatedRef;
import org.kohsuke.stapler.util.IllegalReflectiveAccessLogHandler;

public abstract class MethodRef
extends AnnotatedRef {
    private static final Logger LOGGER = Logger.getLogger(MethodRef.class.getName());

    public boolean isRoutable() {
        return true;
    }

    @CheckForNull
    public String getName() {
        return null;
    }

    public abstract Object invoke(Object var1, Object ... var2) throws InvocationTargetException, IllegalAccessException;

    public static MethodRef wrap(final Method m) {
        return new MethodRef(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> type) {
                return m.getAnnotation(type);
            }

            @Override
            public boolean isRoutable() {
                if (m.isBridge()) {
                    return false;
                }
                return (m.getModifiers() & 1) != 0;
            }

            @Override
            public String getName() {
                return m.getName();
            }

            @Override
            public Object invoke(Object _this, Object ... args) throws InvocationTargetException, IllegalAccessException {
                try {
                    return m.invoke(_this, args);
                }
                catch (IllegalAccessException e) {
                    LOGGER.warning(IllegalReflectiveAccessLogHandler.get(e));
                    m.setAccessible(true);
                    return m.invoke(_this, args);
                }
            }
        };
    }
}

