/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;

class IndexHtmlDispatcher
extends Dispatcher {
    private final URL html;

    IndexHtmlDispatcher(URL html) {
        this.html = html;
    }

    @Override
    public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
        if (!req.tokens.hasMore()) {
            rsp.serveFile(req, this.html, 0L);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "index.html for url=/";
    }

    static Dispatcher make(ServletContext context, Class c) {
        while (c != null && c != Object.class) {
            String name = "/WEB-INF/side-files/" + c.getName().replace('.', '/') + "/index.html";
            try {
                URL url = context.getResource(name);
                if (url != null) {
                    return new IndexHtmlDispatcher(url);
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
            c = c.getSuperclass();
        }
        return null;
    }
}

