/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import jenkins.ClassLoaderReflectionToolkit;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@Extension
@Symbol(value={"assetManager"})
public class AssetManager
implements UnprotectedRootAction {
    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public String getUrlName() {
        return "assets";
    }

    public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        String path = req.getRestOfPath();
        URL resource = this.findResource(path);
        if (resource == null) {
            rsp.setStatus(404);
            return;
        }
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        boolean staticLink = requestPath.startsWith("/static/");
        long expires = staticLink ? TimeUnit.DAYS.toMillis(365L) : -1L;
        rsp.serveLocalizedFile(req, resource, expires);
    }

    @CheckForNull
    private URL findResource(@NonNull String path) throws IOException {
        if (path == null || path.isBlank()) {
            return null;
        }
        if (path.contains("..")) {
            throw new IllegalArgumentException(path);
        }
        String name = path.charAt(0) == '/' ? "assets" + path : "assets/" + path;
        ClassLoader cl = Jenkins.class.getClassLoader();
        URL url = ClassLoaderReflectionToolkit._findResource(cl, name);
        if (url == null) {
            Enumeration<URL> e = cl.getResources(name);
            while (e.hasMoreElements()) {
                url = e.nextElement();
            }
        }
        return url;
    }
}

