/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import hudson.FilePath;
import hudson.model.DownloadService;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.tools.ZipExtractionInstaller;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sf.json.JSONObject;

public abstract class DownloadFromUrlInstaller
extends ToolInstaller {
    public final String id;

    protected DownloadFromUrlInstaller(String id) {
        super(null);
        this.id = id;
    }

    protected boolean isUpToDate(FilePath expectedLocation, Installable i) throws IOException, InterruptedException {
        FilePath marker = expectedLocation.child(".installedFrom");
        return marker.exists() && marker.readToString().equals(i.url);
    }

    public Installable getInstallable() throws IOException {
        for (Installable i : ((DescriptorImpl)this.getDescriptor()).getInstallables()) {
            if (!this.id.equals(i.id)) continue;
            return i;
        }
        return null;
    }

    @Override
    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath expected = this.preferredLocation(tool, node);
        Installable inst = this.getInstallable();
        if (inst == null) {
            log.getLogger().println("Invalid tool ID " + this.id);
            return expected;
        }
        if (inst instanceof NodeSpecific) {
            inst = (Installable)((NodeSpecific)((Object)inst)).forNode(node, log);
        }
        if (this.isUpToDate(expected, inst)) {
            return expected;
        }
        if (expected.installIfNecessaryFrom(new URL(inst.url), log, "Unpacking " + inst.url + " to " + String.valueOf(expected) + " on " + node.getDisplayName())) {
            expected.child(".timestamp").delete();
            FilePath base = this.findPullUpDirectory(expected);
            if (base != null && base != expected) {
                base.moveAllChildrenTo(expected);
            }
            expected.child(".installedFrom").write(inst.url, "UTF-8");
            expected.act(new ZipExtractionInstaller.ChmodRecAPlusX());
        }
        return expected;
    }

    protected FilePath findPullUpDirectory(FilePath root) throws IOException, InterruptedException {
        List<FilePath> children = root.list();
        if (children.size() != 1) {
            return null;
        }
        if (children.get(0).isDirectory()) {
            return children.get(0);
        }
        return null;
    }

    public static class Installable {
        public String id;
        public String name;
        public String url;
    }

    public static abstract class DescriptorImpl<T extends DownloadFromUrlInstaller>
    extends ToolInstallerDescriptor<T> {
        protected DescriptorImpl() {
            DownloadService.Downloadable.all().add(this.createDownloadable());
        }

        public DownloadService.Downloadable createDownloadable() {
            final DescriptorImpl delegate = this;
            return new DownloadService.Downloadable(this.getId()){

                @Override
                public JSONObject reduce(List<JSONObject> jsonList) {
                    if (this.isDefaultSchema(jsonList)) {
                        return delegate.reduce(jsonList);
                    }
                    return super.reduce(jsonList);
                }
            };
        }

        private boolean isDefaultSchema(List<JSONObject> jsonList) {
            ToolInstaller.ToolInstallerEntry sampleEntry;
            ToolInstaller.ToolInstallerEntry[] entryList;
            JSONObject jsonToolInstallerList = jsonList.get(0);
            ToolInstaller.ToolInstallerList toolInstallerList = (ToolInstaller.ToolInstallerList)JSONObject.toBean((JSONObject)jsonToolInstallerList, ToolInstaller.ToolInstallerList.class);
            return toolInstallerList != null && (entryList = toolInstallerList.list) != null && (sampleEntry = entryList[0]) != null && sampleEntry.id != null && sampleEntry.name != null && sampleEntry.url != null;
        }

        private JSONObject reduce(List<JSONObject> jsonList) {
            ArrayList<ToolInstaller.ToolInstallerEntry> reducedToolEntries = new ArrayList<ToolInstaller.ToolInstallerEntry>();
            HashSet<String> processedIds = new HashSet<String>();
            for (JSONObject jsonToolList : jsonList) {
                ToolInstaller.ToolInstallerList toolInstallerList = (ToolInstaller.ToolInstallerList)JSONObject.toBean((JSONObject)jsonToolList, ToolInstaller.ToolInstallerList.class);
                for (ToolInstaller.ToolInstallerEntry entry : toolInstallerList.list) {
                    if (!processedIds.add(entry.id)) continue;
                    reducedToolEntries.add(entry);
                }
            }
            ToolInstaller.ToolInstallerList toolInstallerList = new ToolInstaller.ToolInstallerList();
            toolInstallerList.list = new ToolInstaller.ToolInstallerEntry[reducedToolEntries.size()];
            reducedToolEntries.toArray(toolInstallerList.list);
            return JSONObject.fromObject((Object)toolInstallerList);
        }

        @Override
        public String getId() {
            return this.clazz.getName().replace('$', '.');
        }

        public List<? extends Installable> getInstallables() throws IOException {
            JSONObject d = DownloadService.Downloadable.get(this.getId()).getData();
            if (d == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(((InstallableList)JSONObject.toBean((JSONObject)d, InstallableList.class)).list);
        }
    }

    public abstract class NodeSpecificInstallable
    extends Installable
    implements NodeSpecific<NodeSpecificInstallable> {
        protected NodeSpecificInstallable(Installable inst) {
            this.id = inst.id;
            this.name = inst.name;
            this.url = inst.url;
        }
    }

    public static class InstallableList {
        public Installable[] list = new Installable[0];
    }
}

