/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.JarLoaderImpl;
import hudson.remoting.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class Checksum {
    public final long sum1;
    public final long sum2;

    Checksum(long sum1, long sum2) {
        this.sum1 = sum1;
        this.sum2 = sum2;
    }

    private Checksum(byte[] arrayOf16bytes, int numOfLong) {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(arrayOf16bytes));
            long l1 = 0L;
            long l2 = 0L;
            for (int i = 0; i < numOfLong; ++i) {
                long l = in.readLong();
                if (i % 2 == 0) {
                    l1 ^= l;
                    continue;
                }
                l2 ^= l;
            }
            this.sum1 = l1;
            this.sum2 = l2;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Checksum) {
            Checksum that = (Checksum)o;
            return this.sum1 == that.sum1 && this.sum2 == that.sum2;
        }
        return false;
    }

    public int hashCode() {
        long l = this.sum1 ^ this.sum2;
        return Long.hashCode(l);
    }

    public String toString() {
        return String.format("%016X%016X", this.sum1, this.sum2);
    }

    static Checksum forFile(File file) throws IOException {
        return Checksum.forURL(file.toURI().toURL());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="This is only used for managing the jar cache as files, not URLs.")
    static Checksum forURL(URL url) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance(JarLoaderImpl.DIGEST_ALGORITHM);
            try (InputStream istream = url.openStream();){
                Checksum checksum;
                try (DigestOutputStream ostream = new DigestOutputStream(OutputStream.nullOutputStream(), md);){
                    Util.copy(istream, ostream);
                    checksum = new Checksum(md.digest(), md.getDigestLength() / 8);
                }
                return checksum;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

