/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.parser;

import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.ParserVisitor;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.jexl.util.Coercion;

public class ASTAddNode
extends SimpleNode {
    public ASTAddNode(int id) {
        super(id);
    }

    public ASTAddNode(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext context) throws Exception {
        Object left = ((SimpleNode)this.jjtGetChild(0)).value(context);
        Object right = ((SimpleNode)this.jjtGetChild(1)).value(context);
        if (left == null && right == null) {
            return new Long(0L);
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double || left instanceof String && (((String)left).indexOf(".") != -1 || ((String)left).indexOf("e") != -1 || ((String)left).indexOf("E") != -1) || right instanceof String && (((String)right).indexOf(".") != -1 || ((String)right).indexOf("e") != -1 || ((String)right).indexOf("E") != -1)) {
            try {
                Double l = Coercion.coerceDouble(left);
                Double r = Coercion.coerceDouble(right);
                return new Double(l + r);
            }
            catch (NumberFormatException nfe) {
                return left.toString().concat(right.toString());
            }
        }
        try {
            Long l = Coercion.coerceLong(left);
            Long r = Coercion.coerceLong(right);
            return new Long(l + r);
        }
        catch (NumberFormatException nfe) {
            return left.toString().concat(right.toString());
        }
    }
}

