/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.XmlFile;
import hudson.model.User;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.IdStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Deprecated
@Restricted(value={NoExternalUse.class})
public class UserIdMapper {
    private static final XStream2 XSTREAM = new XStream2();
    private static final Logger LOGGER = Logger.getLogger(UserIdMapper.class.getName());
    private Map<String, String> idToDirectoryNameMap = new ConcurrentHashMap<String, String>();

    private UserIdMapper() {
    }

    static void migrate() throws IOException {
        File[] subdirectories;
        User user;
        XmlFile userXml;
        IdStrategy idStrategy = User.idStrategy();
        File usersDirectory = User.getRootDir();
        UserIdMapper data = new UserIdMapper();
        XmlFile mapperXml = new XmlFile(XSTREAM, new File(usersDirectory, "users.xml"));
        if (mapperXml.exists()) {
            LOGGER.info(() -> "migrating " + String.valueOf(mapperXml));
            mapperXml.unmarshal(data);
            for (Map.Entry<String, String> entry : data.idToDirectoryNameMap.entrySet()) {
                String idKey = entry.getKey();
                String directoryName = entry.getValue();
                try {
                    File oldDirectory = new File(usersDirectory, directoryName);
                    userXml = new XmlFile(User.XSTREAM, new File(oldDirectory, "config.xml"));
                    user = (User)userXml.read();
                    if (user.id == null || !idKey.equals(idStrategy.keyFor(user.id))) {
                        user.id = idKey;
                        userXml.write(user);
                    }
                    File newDirectory = User.getUserFolderFor(user.id);
                    Files.move(oldDirectory.toPath(), newDirectory.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.info(() -> "migrated " + String.valueOf(oldDirectory) + " to " + String.valueOf(newDirectory));
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "failed to migrate " + String.valueOf(entry), x);
                }
            }
            mapperXml.delete();
        }
        if ((subdirectories = usersDirectory.listFiles()) != null) {
            for (File oldDirectory : subdirectories) {
                if (User.HASHED_DIRNAMES.matcher(oldDirectory.getName()).matches() || !(userXml = new XmlFile(User.XSTREAM, new File(oldDirectory, "config.xml"))).exists()) continue;
                try {
                    user = (User)userXml.read();
                    String id = user.id;
                    if (id == null) {
                        user.id = id = idStrategy.idFromFilename(oldDirectory.getName());
                        userXml.write(user);
                    }
                    File newDirectory = User.getUserFolderFor(id);
                    Files.move(oldDirectory.toPath(), newDirectory.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.info(() -> "migrated " + String.valueOf(oldDirectory) + " to " + String.valueOf(newDirectory));
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "failed to migrate " + String.valueOf(oldDirectory), x);
                }
            }
        }
    }
}

